#ifndef __NQS_QUEUE_SHO_HEADER
#define __NQS_QUEUE_SHO_HEADER

/*
 *    The following show flags are for NAS NQS.
 *    Some of these flags the same value as the original
 *    flags.  However, these flags would never be used in
 *    the same case so no question as to the proper meaning
 *    would be inferred
 */
#define SHO_ACCT        00000000002L    /* NOT USED AT THIS TIME Show acct */
#define SHO_GROUP       00000000004L    /* NOT USED AT THIS TIME Show group */
#define SHO_USER        00000000001L    /* Show user */
#define SHO_FULL        00000000400L    /* Show full detail  */
#define SHO_EXTEND      00000001000L    /* Show Extended format vendor ind. */
#define SHO_HOST        00001000000L    /* Show host */
#define SHO_QUE         00002000000L    /* Show queues  */
#define SHO_REQ         00004000000L    /* Show requests */
#define SHO_TARGET      00010000000L    /* Show target user */
#define SHO_NOHDR       00020000000L    /* Show NO headers OR trailers */
#define SHO_LIMITS      00040000000L    /* Show limits / resources */
#define SHO_BATCH       00100000000L    /* Show only batch queues */
#define SHO_PIPE        00200000000L    /* Show only pipe queues */
#define SHO_DEVICE      00400000000L    /* Show only device queues */
#define SHO_CMPLX       01000000000L    /* Show complex */

/*
 *	Show queue and show limit operation flags.
 */
#define	SHO_H_ACCESS	00000001L	/* Show queue access by user & group */
#define	SHO_H_DEST	00000002L	/* Show destinations for pipe queue */
#define SHO_H_LIM	00000004L	/* Show queue quota limits */
#define	SHO_H_MAP	00000010L	/* Show devices for device queue */
#define	SHO_H_RUNL	00000020L	/* Show run limit */
#define	SHO_H_SERV	00000040L	/* Show server for queue */
#define	SHO_H_TIME	00000100L	/* Show CPU usage times */

#define SHO_R_ALLUID	00000200L	/* Show requests belonging to all */
#define	SHO_R_LONG	00000400L	/* Long display of requests */
#define	SHO_R_MONSANTO	00001000L	/* Medium length display of requests */
#define	SHO_R_STANDARD	00002000L	/* Short display of requests */

#define	SHO_RS_EXIT	00004000L	/* Select departing/exiting  requests */
#define	SHO_RS_RUN	00010000L	/* Select running/routing  requests */
#define	SHO_RS_STAGE	00020000L	/* Select staging-in requests */
					/* RESERVED FOR FUTURE USE */
#define	SHO_RS_QUEUED	00040000L	/* Select queued requests */
#define	SHO_RS_WAIT	00100000L	/* Select waiting requests */
#define	SHO_RS_HOLD	00200000L	/* Select holding requests */
#define	SHO_RS_ARRIVE	00400000L	/* Select arriving requests */

#define SHO_SHS		01000000L	/* Show shell strategy (used only by */
					/* qlimit; qstat does not use this) */
#define SHO_R_DEST      02000000L       /* Show jobs from destinations from */
                                        /* this machine */
#define SHO_R_GLOBAL    04000000L       /* All machines everywhere ! */
#define SHO_R_ORIGIN   010000000L       /* Originated on this machine */
#define SHO_R_QUEUE    020000000L       /* Show queue information only, */
                                        /*  not jobs */
#define SHO_R_BRIEF    040000000L       /* Brief, valid only with queues */
#define SHO_R_HEADER  0100000000L       /* force header with monsanto style */
#define SHO_R_COMPLEX 0200000000L      /* Show queue complexes */
#define SHO_H_USRL    0400000000L       /* Show user limit */

#endif /* __NQS_QUEUE_SHO_HEADER */
