/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ shodbydesc.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/lib/RCS/shodbydesc.c,v $
 *
 * DESCRIPTION:
 *
 *	Show status information for the specified local NQS device.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1993/09/10 13:55:21 $ $State: Exp $)
 * $Log: shodbydesc.c,v $
 * Revision 1.3  1993/09/10  13:55:21  jrroma
 * Version 3.35
 *
 * Revision 1.2  92/06/18  13:24:46  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:50:23  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"

/*** shodbydesc
 *
 *
 *	int shodbydesc():
 *	Show status information for the specified local NQS device.
 *
 *	Returns:
 *		This function always returns 0.
 *
 */
int shodbydesc (struct gendescr *descr)
{
	char hostname [256];		/* 255-char host names */

	gethostname (hostname, 255);	/* Get the name of the local host */
	hostname [255] = '\0';		/* Make absolutely sure that it is */
					/* null terminated */
	printf ("  %s@%s\n", descr->v.dev.dname, hostname);
	printf ("  Fullname: %s\n", descr->v.dev.fullname);
	printf ("  Server: %s\n", descr->v.dev.server);
	printf ("  Forms: %s\n", descr->v.dev.forms);
	printf ("  Status = [");
	if (descr->v.dev.status & DEV_ENABLED) printf ("ENABLED, ");
	else if (descr->v.dev.status & DEV_ACTIVE) {
		printf ("ENABLED/CLOSED, ");
	}
	else printf ("DISABLED, ");
	if (descr->v.dev.status & DEV_FAILED) printf ("FAILED");
	else if (descr->v.dev.status & DEV_ACTIVE) printf ("ACTIVE");
	else printf ("INACTIVE");
	if (descr->v.dev.statmsg [0] != '\0') {
		/*
		 *  Device status message text is defined for this device.
		 *  Display it.
		 */
		printf (", %s", descr->v.dev.statmsg);
	}
	printf ("];\n");
	if (descr->v.dev.status & DEV_ACTIVE) {
		/*
		 *  The device is active and handling a request.
		 *  Display a certain amount of information about
		 *  the current request being handled.
		 */
		printf ("  Request name=%s;  id=%1ld.%s\n",
			descr->v.dev.reqname, descr->v.dev.orig_seqno,
			getmacnam (descr->v.dev.orig_mid));
		printf ("  Owner=%8s;\n", getusenam (descr->v.dev.uid));
	}
	return (0);			/* Output produced */
}
