#ifndef __NQS_COMMS_NPK_HEADER
#define __NQS_COMMS_NPK_HEADER

/*
 * nqs_comms/NPK.h
 * Network packet codes for Monsanto-NQS
 */

#include <nqs_generic/license.h>

/*
 * NOTES:
 * 
 * 	(1) The NPK codes defined here are used at both local and remote
 * 	    machines.  Changing these values will result in making Monsanto-NQS
 * 	    incompatible with other NQS implementations.
 * 
 * 	(2) It is safe to add new codes to the existing set.  If you do so, you
 * 	    should mark them as either :
 * 
 * 		INTERNAL: code is intended for use by Monsanto-NQS only.  Its
 *		functionality may change, or be removed, without warning.  Use
 * 		of this code by any software other than Monsanto-NQS is
 * 		completely unsupported.
 * 
 * 		EXTERNAL: code represents an extension to the NQS protocol.
 * 		Its functionality will be preserved in all subsequent revisions
 * 		of Monsanto-NQS.  Use of this code by any software other than
 * 		Monsanto-NQS is supported.
 */


#define	NPK_MAGIC1	0x4E515301	
  /* Magic# used in establish() connect protocol */

/*
 *	NQS network packet types.
 *
 *	Batch request and device request packets.
 */
#define	NPK_QUEREQ	0
  /* Remotely queue a request */
#define	NPK_DELREQ	1
  /* Remotely delete a request RESERVED for future use */
#define	NPK_COMMIT	2
  /* Remotely commit some action, such as the queueing of a request */

/*
 *	NQS local server connection packet.
 *
 *	This packet is sent by a local NQS client process to the local
 *	NQS network daemon, whenever a connection must be established
 *	from a local client process to the local NQS daemon.
 *
 *	This packet is used ONLY for UNIX implementations that do NOT
 *	support named-pipes (i.e. Berkeley 4.2 and 4.3).
 */
#define	NPK_SERVERCONN	90
  /* Local server connect packet */

/*
 *	File system packets.
 *
 *	The following actions involving the file system are
 *	undertaken in such a way as to insure their failure
 *	if the user on whose behalf they are being executed
 *	lacks the necessary permissions.
 */
#define NPK_DONE	100
  /* Marks the end of an iterative conversation */
#define NPK_MKDIR	101
  /* Make a directory RESERVED for future use */
#define	NPK_REQFILE	102
  /* Deliver a file for a previously queued request */
#define	NPK_CPINFILE	103
  /* Copy-in a file RESERVED for future use */
#define	NPK_CPOUTFILE	104
  /* Copy-out a file RESERVED for future use */
#define	NPK_MVINFILE	105
  /* Move-in a file RESERVED for future use */
#define	NPK_MVOUTFILE	106
  /* Move-out a file */
#define NPK_SUSPENDREQ  207
  /* Remote suspend / resume  */

/*
 *	Status packets.
 */
#define	NPK_QDEV	200
  /* Remote Qdev startup packet RESERVED for future use */
#define	NPK_QLIMIT	201
  /* Remote Qlimit startup packet RESERVED for future use */
#define	NPK_QMGR	202
  /* Remote Qmgr startup packet RESERVED for future use */
#define	NPK_QSTAT	203
  /* Remote Qstat startup packet */
#define NPK_LOAD	204
  /* Load status packet */
#define NPK_RREQCOM	205
  /* Request completion packet */

#endif /* __NQS_COMMS_NPK_HEADER */
