/*
 * nqs_generic/BSD/bytezero.c
 * Zero blocks of memory
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */

/*** bytezero
 *
 *	bytezero():
 *	Zero-out exactly N bytes.
 */
void bytezero (char *to, int n)
{
  ENTER_FUNCTION("nqs_generic/BSD/bytezero");
  
  TEST_ARG(to != NULL, 1);
  TEST_ARG(n  >  0,    2);
  
  bzero(to, n);
  
  EXIT_FUNCTION;
}
