
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmdmp.h
 */

#define TIMEOUT     10000       /* for select(); in usec */
/* determine if task is a node process */
#define TIDONNODE   0x00020000  /* this bit is set for node tasks */
#define TIDISNODE(tid)  ((tid) & (TIDONNODE))

void mpp_init __ProtoGlarp__((int *argc, char **argv));
void mpp_free __ProtoGlarp__((int tid));
int mpp_load __ProtoGlarp__((int flags, char *name, char **argv, int count,
    int *tids, int ptid));
void mpp_input __ProtoGlarp__((void));
int mpp_mcast __ProtoGlarp__((struct pkt *pp, int *tids, int ntask));
void mpp_output __ProtoGlarp__((struct task *tp, struct pkt *pp));
int mpp_probe __ProtoGlarp__((void));
void mpp_kill __ProtoGlarp__((struct task *tp, int signum));
void mpp_cleanup __ProtoGlarp__((void));

void wakesig __ProtoGlarp__((int sig));
