
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *  pvmmimd.h
 *
$Log: pvmmimd.h,v $
 * Revision 1.4  1994/11/08  19:19:23  manchek
 * mpp fixes
 *
 * Revision 1.3  1994/06/03  20:38:25  manchek
 * version 3.3.0
 *
 * Revision 1.2  1993/12/20  15:39:44  manchek
 * patch 6 from wcj
 *
 * Revision 1.1  1993/08/30  23:26:51  manchek
 * Initial revision
 *
 */

/* iPSC/860 */

#ifdef IMA_I860
#define CUBENAMELEN		16		/* max number of characters in cube name */
#define MAKECUBENAME(name,no)	(sprintf((name),"pvm%d",(no)))
#endif


/*
 * message handling routines
 *
 * ASYNCWAIT():		waits for asynchronous send/recv to complete
 * ASYNCDONE():		returns 1 if the asynchronous send/recv has completed; 0
 *					otherwise
 * ASYNCSEND():		asynchronous send
 * ASYNCRECV():		asynchronous receive
 * MSGSIZE():		length (in bytes) of pending/received message
 * MSGSENDER():		address of the sender
 */

#ifdef IMA_CM5

#include <cm/cmmd.h>
#define ASYNCDONE(mid)	CMMD_msg_done(mid)
#define ASYNCWAIT(mid)	CMMD_msg_wait(mid)
#define MSGSIZE(mid)	CMMD_mcb_bytes(mid)
#define MSGSENDER(mid)	CMMD_mcb_source(mid)
#define MSGTAG(mid)		CMMD_mcb_tag(mid)
#define ASYNCRECV(buf,len) \
	CMMD_receive_async(CMMD_ANY_NODE,CMMD_ANY_TAG,buf,len,(void*)0,(void*)0)
#define ASYNCSEND(tag,buf,len,dest,ptype) \
	CMMD_send_async((int)(dest),tag,buf,len,(void*)0,(void*)0)
#define PVMCSEND(tag,buf,len,dest,ptype) \
	CMMD_send_noblock((int)(dest),tag,buf,len)
#define PVMCRECV(src,tag,buf,len,ptype,info) \
	CMMD_receive_block((int)src,tag,buf,len)
#define MSGPROBE(tag)	CMMD_msg_pending(CMMD_ANY_NODE,tag)
#define NUMSMIDS	90			/* the CM5 has about 100 message IDs */

#endif /*IMA_CM5*/

#if defined(IMA_PGON) || defined(IMA_I860)

#define ASYNCDONE(mid)	_msgdone(mid)
#define ASYNCWAIT(mid)	_msgwait(mid)
#define MSGSIZE(mid)	_infocount()
#define MSGSENDER(mid)	_infonode()
#define MSGTAG(mid)		_infotype()
#define MSGPROBE(tag)	_iprobe(tag)
#define ASYNCRECV(buf,len)					_irecv((long)recvmask,buf,(long)len)
#define ASYNCSEND(tag,buf,len,dest,ptype)	_isend(tag,buf,(long)len,dest,ptype)
#define PVMCSEND(tag,buf,len,dest,ptype)	_csend(tag,buf,(long)len,dest,ptype)
#define NUMSMIDS	64			/* the Paragon has 999 message IDs (snd/recv) */
								/* msg buffer for Paragon holds 1MB; = 64x16K */
/*
#ifdef IMA_I860
#define NUMSMIDS    1
#endif
*/

#endif /*IMA_PGON/IMA_I860*/

#ifdef IMA_PGON
#define PVMCRECV(src,tag,buf,len,ptype,info) \
	_crecvx(tag,buf,(long)len,src,ptype,info)
#endif
#ifdef IMA_I860
#define PVMCRECV(src,tag,buf,len,ptype,info) _crecv(tag,buf,(long)len)
#endif

/* nodes in use */

struct nodeset {
	struct nodeset *n_link;		/* linked list */
	struct nodeset *n_rlink;
	int n_size;					/* number of nodes */
	int n_first;				/* the first node in the set */
	int n_ptype;				/* (PGON) ptype of tasks on the nodes  */
	int n_alive;				/* number of active nodes */
	int n_ptid;					/* tid of task who spawned us */
#ifdef IMA_I860
#define n_cid	n_ptype			/* the global qm_cubeid */
	char *n_name;				/* cube name */
#endif
};

/* tid fields */

#define TIDNODE		0x000007ff	/* 11 bits for node number */
#define TIDPTYPE	0x0001f800	/* 6 bits for process type */

#ifndef TIDONNODE
#define TIDONNODE	0x00020000	/* this bit is set for node tasks */
/* determine if task is a node process */
#define TIDISNODE(tid)	((tid) & (TIDONNODE))
#endif /*TIDONNODE*/

#define NUMPTYPE	64			/* (PGON) num of active proc types allowed */
#define PVMDPTYPE	0			/* process type of pvmd */
#define PDMNODE		128			/* pvmd debug mask */
#define MAXFRAGSIZE	0x00004000	/* max fragment size (16K) */
#define SIZEHINFO	5			/* size of hostinfo array */

/* extract the ptype bits */
#define TIDTOTYPE(tid)  (tid & tidtmask) >> (ffs(tidtmask) - 1)

/* pvm internal message types */

#define PMTPACK		999999001	/* packed messages */
#define PMTHOST		(PMTPACK+1)	/* broadcast myhostpart to all nodes */
#define PMTPHYS		(PMTPACK+2)	/* (iPSC/860) msg containing physical node # */
