
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	tdpro.h
 *
 *	Task-pvmd protocol
 *
$Log: tdpro.h,v $
 * Revision 1.3  1994/06/03  20:38:31  manchek
 * version 3.3.0
 *
 * Revision 1.2  1993/10/04  20:30:50  manchek
 * added alternate TDSOCKNAME if SHAREDTMP is defined
 *
 * Revision 1.1  1993/08/30  23:26:52  manchek
 * Initial revision
 *
 */


/* protocol version */

#ifndef	TDPROTOCOL
#define	TDPROTOCOL	1317
#endif

/* message/frag hdr sizes */

#define	TDFRAGHDR	16
#define	TTMSGHDR	16
#define	MAXHDR		((DDFRAGHDR > TDFRAGHDR ? DDFRAGHDR : TDFRAGHDR) \
					+ (DDMSGHDR > TTMSGHDR ? DDMSGHDR : TTMSGHDR))

#ifdef	SHAREDTMP
#define	TDSOCKNAME	"/tmp/pvmd.%d.%s"	/* file with task->pvmd sockaddr */
#else
#define	TDSOCKNAME	"/tmp/pvmd.%d"	/* file with task->pvmd sockaddr */
#endif

#define	TM_FIRST	0x80010001		/* first TM_ message */
#define	TM_CONNECT	(TM_FIRST+0)	/* task connects */
#define	TM_CONN2	(TM_FIRST+1)	/* 2nd round of connect */
#define	TM_EXIT		(TM_FIRST+2)	/* task disconnects */
#define	TM_ADDHOST	(TM_FIRST+3)	/* add hosts to machine */
#define	TM_DELHOST	(TM_FIRST+4)	/* delete hosts from machine */
#define	TM_CONFIG	(TM_FIRST+5)	/* get machine config */
#define	TM_MSTAT	(TM_FIRST+6)	/* get host status */
#define	TM_HALT		(TM_FIRST+7)	/* halt machine */
#define	TM_TICKLE	(TM_FIRST+8)	/* tickle pvmd */
#define	TM_SPAWN	(TM_FIRST+9)	/* spawn new tasks */
#define	TM_PSTAT	(TM_FIRST+10)	/* get task status */
#define	TM_SENDSIG	(TM_FIRST+11)	/* signal a task */
#define	TM_TASK		(TM_FIRST+12)	/* list tasks */
#define	TM_MCA		(TM_FIRST+13)	/* request multicast tid */
#define	TM_NOTIFY	(TM_FIRST+14)	/* request notification */
#define	TM_DB		(TM_FIRST+15)	/* name-server request */
#define	TM_SCHED	(TM_FIRST+16)	/* register task as scheduler */
#define	TM_TASKER	(TM_FIRST+17)	/* register task as task starter */
#define	TM_HOSTER	(TM_FIRST+18)	/* register task as pvmd starter */
#define	TM_HOSTSYNC	(TM_FIRST+19)	/* get clock delta to host */
#define	TM_SETOPT	(TM_FIRST+20)	/* set task parameters */
#define	TM_LAST		(TM_FIRST+20)	/* last TM_ message */

#define	TMDB_INSERT	1
#define	TMDB_DELETE	2
#define	TMDB_LOOKUP	3

/*
* for TM_SETOPT
*/

#define	TS_OUTTID	1				/* stdout dst */
#define	TS_OUTCOD	2				/* stdout message tag */
#define	TS_TRCTID	3				/* trace dst */
#define	TS_TRCCOD	4				/* trace message tag */

#define	TC_FIRST	0x80030001		/* first TC_ message */
#define	TC_CONREQ	(TC_FIRST+0)	/* connection request */
#define	TC_CONACK	(TC_FIRST+1)	/* connection request ack */
#define	TC_TASKEXIT	(TC_FIRST+2)	/* task exited/doesn't exist */
#define	TC_NOOP		(TC_FIRST+3)	/* do nothing */
#define	TC_OUTPUT	(TC_FIRST+4)	/* child stdout data */
#define	TC_SETTMASK	(TC_FIRST+5)	/* set task trace mask */
#define	TC_LAST		(TC_FIRST+5)	/* last TC_ message */

