/* Recent.h */

typedef struct RemoteSiteInfo *RemoteSiteInfoPtr;
typedef struct RemoteSiteInfo {
	RemoteSiteInfoPtr	prev;
	RemoteSiteInfoPtr	next;
	int					index;
	
	char				nickName[16];
	char				name[64];
	char				user[64];	/* Leave room for user@host.name */
	char				pass[32];
	char				acct[16];
	char				dir[128];
	int					xferType;
	unsigned int		port;
	time_t				lastCall;
	int					hasSIZE;
	int					hasMDTM;
	int					hasPASV;
	int					isUnix;
	char				lastIP[32];
	char				comment[128];
	long				xferKbytes;
	long				xferHSeconds;
	int					nCalls;
} RemoteSiteInfo;

typedef RemoteSiteInfoPtr *RemoteSiteInfoPtrList;

#define kRecentVersion			5
#define kRecentMinVersion		3
#define kRecentFileName			"hosts"
#define kRecentBupFileName		"hosts.old"

#define kNoRecentLimit 0

void SortNickNames(void);
void UpdateRemoteSiteInfoPtr(RemoteSiteInfoPtr, RemoteSiteInfoPtr);
RemoteSiteInfoPtr AddRemoteSiteInfoPtr(RemoteSiteInfoPtr);
RemoteSiteInfoPtr RemoveRemoteSiteInfoPtr(RemoteSiteInfoPtr);
void MakeNickNameUnique(char *, size_t);
void MakeUpANickName(char *, size_t, char *);
void SetRemoteInfoDefaults(RemoteSiteInfoPtr);
void SetNewRemoteInfoDefaults(RemoteSiteInfoPtr);
int GetRemoteInfo(char *, size_t);
int ParseHostLine(char *, RemoteSiteInfoPtr);
void ReadRemoteInfoFile(void);
RemoteSiteInfoPtr DuplicateRemoteInfo(RemoteSiteInfoPtr);
void DeleteRemoteInfo(RemoteSiteInfoPtr);
void SaveRemoteInfo(char *);
void WriteRemoteInfoFile(void);

/* eof */
