/*
 * Configuration file for CFINGERD
 * by Ken Hollis
 *
 * Edit this file after configuration
 */

/*
 * GRACE PERIOD
 *
 * This is the grace period that is used for initial fingers.  If you have
 * a faster machine, you will want to have a grace period of about 1 - 3
 * seconds to get inetd settled, and the loaded information time to
 * propogate.  On SunOS, this should be 3.  Otherwise, it should be 0.
 */
#define	GRACE_PERIOD	0

/*
 * TIMEOUT
 *
 * This is the number of seconds that are given before cfingerd times out
 * and closes the connection.  Default is 10.  If "0" is given here, cfingerd
 * will never time out on a hung port.
 */
#define	TIMEOUT		10

/*
 * WHOIS
 *
 * This is the name of the program that is used when someone tries to
 * find out a WHOIS on your site, using the "/W" directive on your system.
 * The default is "/usr/bin/whois" or "/usr/ucb/whois".
 */
#define	WHOIS		"/usr/bin/whois"

/*
 * SYSLOG
 *
 * If you want information to be displayed in your syslog output, you can
 * define this, otherwise, undefine it.  Default is defined.
 */
#define	SYSLOG

/*
 * NOBODY UID
 *
 * This is the nobody user-id, defined on your system.  There is no default.
 */
#define	NOBODY_UID	0

/*
 * NOBODY GID
 *
 * This is the nobody group-id, defined on your system.  There is no default.
 */
#define	NOBODY_GID	0

/*
 * CFINGER_CONF
 *
 * The directory and name of the configurable finger daemon configuration
 * file.  Default is "/etc/cfingerd.conf"
 */
#define	CFINGER_CONF	"/etc/cfingerd.conf"
