#!/bin/sh 
#Calculate unique TCP port based on PID
start=${1-c=GB}
ppid=$$
gooddsa=0
baddsa=0
ditsize=0
if ( test $ppid-lt10000 )
then
	ppid=`expr $ppid + 10000`
fi
DISHPROC="127.0.0.1 $ppid"
export DISHPROC
if ( bind -noa )
then
	echo -n
else
	exit 1
fi
moveto @
if [ $start != "root" ]
then 
	moveto $start
fi
for j in `search -filter objectclass=quipuDSA -nosize -time 500 -type presentationaddress -noname -singlelevel`
do
	echo -n "Trying "
	moveto -nocheck -pwd $j
	if ( bind -c `showentry -type presentationaddress -nokey` -noa 2>/dev/null )
	then 
		gooddsa=`expr $gooddsa + 1`
		if ( dsacontrol -info > /tmp/dsainfo 2>/dev/null )
		then
			dsasize=`awk < /tmp/dsainfo '{ printf $1 }'`
			echo Size $dsasize
			ditsize=`expr $ditsize + $dsasize`
		else
			echo Contacted
		fi
	else
		echo Failed
		baddsa=`expr $baddsa + 1`
	fi
done
echo
echo $gooddsa DSAs contacted
echo $baddsa connections failed
echo
echo Counted $ditsize entries
rm -f /tmp/dsainfo
unbind
