/*                               -*- Mode: C -*- 
 * ssl.h -- 
 * Copyright (c) 1995 Shaun Savage.
 * All rights reserved.
 *
 * Author          : Shaun Savage
 * Created On      : Sun May  7 17:19:19 1995
 * Last Modified By: Shaun Savage
 * Last Modified On: Sun May  7 17:20:16 1995
 * Update Count    : 1
 * Status          : Unknown, Use with caution!
 * PURPOSE
 * 	|>Description of modules purpose<|
 * TABLE OF CONTENTS
 * 
 */

#ifndef _SSL_H_
#define _SSL_H_

#define SSL_LIBRARY_VERSION			3

/* Security handshake protocol codes */
#define SSL_MT_ERROR				0
#define SSL_MT_CLIENT_HELLO			1
#define SSL_MT_CLIENT_MASTER_KEY		2
#define SSL_MT_CLIENT_FINISHED			3
#define SSL_MT_SERVER_HELLO			4
#define SSL_MT_SERVER_VERIFY			5
#define SSL_MT_SERVER_FINISHED			6
#define SSL_MT_REQUEST_CERTIFICATE		7
#define SSL_MT_CLIENT_CERTIFICATE		8

/* Cypher kind's */
#define SSL_CK_NULL			        0x00000000
#define SSL_CK_RC4_128_WITH_MD5			0x00010080
#define SSL_CK_RC4_128_EXPORT40_WITH_MD5	0x00020080
#define SSL_CK_RC2_128_CBC_WITH_MD5		0x00030080
#define SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5	0x00040080
#define SSL_CK_IDEA_128_CBC_WITH_MD5		0x00050080
#define SSL_CK_DES_64_CBC_WITH_MD5		0x00060040
#define SSL_CK_DES_192_EDE3_CBC_WITH_MD5	0x000700C0

/* Certificate type's */
#define SSL_CT_X509_CERTIFICATE			0x01

/* Authentication type's */
#define SSL_AT_MD5_WITH_RSA_ENCRYPTION		0x01

/* Error codes */
#define SSL_PE_NO_CIPHERS			0x0001
#define SSL_PE_NO_CERTIFICATE			0x0002
#define SSL_PE_BAD_CERTIFICATE			0x0004
#define SSL_PE_UNSUPPORTED_CERTIFICATE_TYPE	0x0006

/* Limits */
#define SSL_MAX_BLOCK_CYPHER_LEN	0x3fff


#define ERROR_NO_CERTIFICATE		-2
#define ERROR_BAD_CERTIFICATE		-4
#define ERROR_UNSUPPORTED_CERTIFICATE_TYPE	-6
#define ERROR_IO				-10
#define ERROR_BAD_MESSAGE			-11
#define ERROR_BAD_MAC			-12
#define ERROR_UNSUPPORTED			-13
#define ERROR_BAD_CERT_SIG			-14
#define ERROR_BAD_CERT			-15
#define ERROR_BAD_PEER			-16

/************************************************************************/

#define MD5_LEN		16
#define CIDSIZE         16
#define CHALSIZE        16
#define SIDSIZE         16

#define NTOHS(ptr)      ntohs(*(short*)(ptr))
#define HTONS(ptr,val)   ((*(short*)(ptr)) = (htons(val));( ptr+=2))
#define NTOHL(ptr)      ntohl(*(long*)(ptr))

#define EN0 0
#define DE1 1

typedef struct _certRec {
   char   cerType;
   u_char *cert;
   short  certLen;
} certRec;

typedef struct _crypto {
   u_long cph;
   int padnum;

   int mkeyLen; u_char *mKey;
   int argLen;  u_char *arg;

   int keyLen;  u_char *rdKey; u_char *wrKey;
   int cxLen;   void* context;
   int (*init)();
   int (*update)();
   int (*finish)();
   int (*enCrypt)();
   int (*deCrypt)();
   int (*mkKey)();
} crypto;

typedef struct _sidRec {
   short sidLen;
   u_char *sid;
   crypto *crypt;
   int clrLen;
   int keyLen;
   int argLen;
   u_char* key;
   u_char* arg;
} sidRec;
     
typedef struct _Ciphers {
   u_long type;
   char   *name;
   crypto *crypt;
} Ciphers;

typedef struct _ssllib {
#ifdef BLOCK_MSG
   StreamInfo *wfile, *rfile; 
#else
   int fd;
#endif
   int server;

   int hit;
   sidRec *sid;
   
   u_long *cph;
   short   cphLen;
   crypto *pubCrypt;

   int wrSeq;
   int rdSeq;

   int authLen;
   int authType;
   u_char *authh;

   int chalLen;
   int cidLen;
   u_char *cid;
   u_char *chal;
} ssllib;

extern char pname[];
extern short cipherCnt;
extern Ciphers cipherTypes[];
extern certRec cert[];
extern sidRec sidCache[];
extern sidRec clientSid[];
extern int noRSA;
#define UAUTH_LEN 16
#define UKEY_LEN 16;
extern u_char UAuth[];
extern u_char UKey[];

extern ssllib* srv_init(ssllib* ssl);
extern int srv_handshake(ssllib* ssl);
extern int srv_recvHello(ssllib* ssl);
extern int srv_sendHello(ssllib* ssl);
extern int srv_recvMKey(ssllib* ssl);
extern int srv_sendVerify(ssllib* ssl);
extern int srv_recvFinish(ssllib* ssl);
extern int srv_sendFinish(ssllib* ssl);
extern int srv_sendAuth(ssllib* ssl);
extern int srv_recvAuth(ssllib* ssl);
extern int chkAuth(ssllib* ssl, int authType, u_char *auth, int authLen);

extern ssllib* cli_init(ssllib* ssl);
extern int cli_handshake(ssllib* ssl);
extern int cli_recvHello(ssllib* ssl);
extern int cli_sendHello(ssllib* ssl);
extern int cli_sendMKey(ssllib* ssl);
extern int cli_recvVerify(ssllib* ssl);
extern int cli_parseFinish(ssllib* ssl, u_char *buf, int len);
extern int cli_sendFinish(ssllib* ssl);
extern int cli_sendAuth(ssllib* ssl);
extern int cli_parseAuth(ssllib* ssl, u_char *buf, int len);
extern int genMKey(ssllib* ssl);
extern int mkAuth();

extern int chkCert(ssllib* ssl, char certType, u_char* cert, u_short certLen);
extern int selCipher(ssllib* ssl, u_long* cipher, u_short cphLen);
extern void MakeKeys(ssllib* ssl);
extern sidRec * findSID(ssllib *ssl, u_char *buf, int len);
extern int sslError(int, char*);
extern u_char * Copy(u_char* to,u_char* from, int len);
extern int chkChal(ssllib *ssl, u_char *buf, int len);
extern int chkSID(sidRec *sid, u_char *buf, int len);
extern int chkCID(ssllib *ssl, u_char *buf, int len);
extern int getAuthLen(int);
extern int getCertLen(int);
extern int mkCert();
extern void host_info(char*,char*);
extern int rdMsg(ssllib* ssl, u_char* str, int len);
extern int wrMsg(ssllib* ssl, u_char* str, int len);
extern int wrClrMsg(ssllib* ssl, u_char* str, int len);
extern int rdClrMsg(ssllib* ssl, u_char* str, int len);
extern void addSID(sidRec *sid);

extern crypto dummyCrypt;
extern crypto *CryptCopy(crypto* to, crypto* from);
extern void genRand(u_char* str, int len);
extern void keyMaterial(ssllib * ssl, u_char *buf, char *str);
extern int privSID();
 
#endif /* _SSL_H_ */






