#include "stat.h"
#include "curs.h"
#include <ncurses.h>
#include <signal.h>
#include <unistd.h>

void
itstime (int errnum)
{
  extern struct registers regis;
  int len, noframes;
  long int nobytes;
  char eth[20];
  WINDOW *genwin, *etherwin, *plipwin, *typewin;

  nobytes = regis.etherbytes + regis.plipbytes + regis.otherbytes;
  noframes = regis.ethercount + regis.plipcount + regis.othercount;

  if (regis.g)
    {
      genwin = subwin (stdscr, 6, 22, 3, 10);
      mvwprintw (genwin, 0, 0, "GENERAL");
      mvwprintw (genwin, 2, 0, "Kb/sec:        %7.2f",
		 nobytes / 1024.0);
      mvwprintw (genwin, 3, 0, "Frames/sec:    %7d", noframes);
      if (noframes == 0)
	{
	  len = 0;
	  noframes = 1;		/* dirty, i know, but it's easier and doesn't give errors*/
	}
      else
	len = nobytes / noframes;
      mvwprintw (genwin, 4, 0, "Av. frame len: %7d", len);
    }


  if (regis.e)
    if (regis.g)
      etherwin = subwin (stdscr, 6, 22, 10, 10);
    else
      etherwin = subwin (stdscr, 6, 22, 3, 10);
  {
    strcpy (eth, "ETHERNET: ");
    strncat (eth, ETH, 9);
    mvwprintw (etherwin, 0, 0, eth);
    mvwprintw (etherwin, 2, 0, "Kb/sec:        %7.2f",
	       regis.etherbytes / 1024.0);
    mvwprintw (etherwin, 3, 0, "Frames/sec:    %7d",
	       regis.ethercount);
    if (regis.ethercount == 0)
      len = 0;
    else
      len = regis.etherbytes / regis.ethercount;
    mvwprintw (etherwin, 4, 0, "Av. frame len: %7d", len);
    mvwprintw (etherwin, 5, 0, "Load:          %6.2f%%",
	       regis.etherbytes * 100.0 / 1250000.0);
  }


  if (regis.p)
    if (regis.g)
      if (regis.e)
	plipwin = subwin (stdscr, 6, 22, 18, 10);
      else
	plipwin = subwin (stdscr, 6, 22, 10, 10);
    else if (regis.e)
      plipwin = subwin (stdscr, 6, 22, 10, 10);
    else
      plipwin = subwin (stdscr, 6, 22, 3, 10);
  {
    mvwprintw (plipwin, 0, 0, "PLIP");
    mvwprintw (plipwin, 2, 0, "Kb/sec:        %7.2f",
	       regis.plipbytes / 1024.0);
    mvwprintw (plipwin, 3, 0, "Frames/sec:    %7d",
	       regis.plipcount);
    if (regis.plipcount == 0)
      len = 0;
    else
      len = regis.plipbytes / regis.plipcount;
    mvwprintw (plipwin, 4, 0, "Av. frame len: %7d", len);
  }


  if (regis.t)
    if (regis.g || regis.e || regis.p)
      typewin = subwin (stdscr, 20, 40, 3, 40);
    else
      typewin = subwin (stdscr, 20, 40, 3, 6);
  {
    mvwprintw (typewin, 0, 0, "TYPES PER SECOND");
    mvwprintw (typewin, 2, 0, "IP:       %7d %6.1f%%", regis.ip, regis.ip * 100.0 / noframes);
    mvwprintw (typewin, 3, 0, "ARP:      %7d %6.1f%%", regis.arp, regis.arp * 100.0 / noframes);
    mvwprintw (typewin, 4, 0, "RARP:     %7d %6.1f%%", regis.rarp, regis.rarp * 100.0 / noframes);
    mvwprintw (typewin, 5, 0, "IPX:      %7d %6.1f%%", regis.ipx, regis.ipx * 100.0 / noframes);
    mvwprintw (typewin, 7, 0, "Appletalk");
    mvwprintw (typewin, 9, 0, "AARP:     %7d %6.1f%%", regis.aarp, regis.aarp * 100.0 / noframes);
    mvwprintw (typewin, 10, 0, "RTMPRD:   %7d %6.1f%%", regis.rtmprd, regis.rtmprd * 100.0 / noframes);
    mvwprintw (typewin, 11, 0, "RTMPREQ:  %7d %6.1f%%", regis.rtmpreq, regis.rtmpreq * 100.0 / noframes);
    mvwprintw (typewin, 12, 0, "NBP:      %7d %6.1f%%", regis.nbp, regis.nbp * 100.0 / noframes);
    mvwprintw (typewin, 13, 0, "ATP:      %7d %6.1f%%", regis.atp, regis.atp * 100.0 / noframes);
    mvwprintw (typewin, 14, 0, "AEP:      %7d %6.1f%%", regis.aep, regis.aep * 100.0 / noframes);
    mvwprintw (typewin, 15, 0, "ZIP:      %7d %6.1f%%", regis.zip, regis.zip * 100.0 / noframes);
    mvwprintw (typewin, 16, 0, "ADSP:     %7d %6.1f%%", regis.adsp, regis.adsp * 100.0 / noframes);
    mvwprintw (typewin, 19, 0, "Other:    %7d %6.1f%%", regis.unknown_type, regis.unknown_type * 100.0 / noframes);
  }



  touchwin (stdscr);
  refresh ();

  set_null ();

  if (signal (SIGALRM, itstime) == SIG_ERR)
    {
      perror ("Signal error: ");
      exit (5);
    }
  alarm (1);
  return;
}
