/* @(#) $Header: tcpdump.c,v 1.5 91/05/09 07:38:56 deyke Exp $ */

/* TCP header tracing routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"

#define	FIN	0x01
#define	SYN	0x02
#define	RST	0x04
#define	PSH	0x08
#define	ACK	0x10
#define	URG	0x20
#define	CE	0x40

#define	TCPLEN	20

/* Dump a TCP segment header. Assumed to be in network byte order */
void tcp_dump(unsigned char *data, int length)
{
	int source, dest;
	int seq;
	int ack;
	int flags;
	int wnd;
	int up;

	source = get16(data + 0);
	dest   = get16(data + 2);
	seq    = get32(data + 4);
	ack    = get32(data + 8);
	flags  = data[13];
	wnd    = get16(data + 14);
	up     = get16(data + 18);

	fprintf(stdout, "TCP: %d->%d Seq x%lx", source, dest, seq, ack);

	if (flags & ACK) fprintf(stdout, " Ack x%lx", ack);

	if (flags & CE)  fprintf(stdout, " CE");

	if (flags & URG) fprintf(stdout, " URG");

	if (flags & ACK) fprintf(stdout, " ACK");

	if (flags & PSH) fprintf(stdout, " PSH");

	if (flags & RST) fprintf(stdout, " RST");

	if (flags & SYN) fprintf(stdout, " SYN");

	if (flags & FIN) fprintf(stdout, " FIN");

	fprintf(stdout, " Wnd %d", wnd);

	if (flags & URG) fprintf(stdout, " UP x%x", up);

	/* Print options, if any */
	/*
	if (mss != 0) fprintf(stdout," MSS %d", mss);
	*/

	length -= TCPLEN;
	data   += TCPLEN;

	if (length > 0)
	{
		fprintf(stdout, " Data %d\n", length);
		data_dump(data, length);
		return;
	}
	
	putc('\n', stdout);
}

