#include "diald.h"
#ifdef BUFFER_PACKETS

#define B(i) buffer[(i)%BUFFER_SIZE]

static unsigned char buffer[BUFFER_SIZE];
static int head = 0;
static int used = 0;
static int tail = 0;

void buffer_packet(unsigned int len,unsigned char *pkt)
{
    unsigned int clen;
#ifndef BUFFER_FIFO_DISPOSE
    unsigned long stamp;
#endif
    unsigned long ctime = timestamp();

    if (len+4 > BUFFER_SIZE) {
	syslog(LOG_ERR,"Can't buffer packet of length %d, buffer to small.",
	    len);
	return;
    }
#ifdef BUFFER_FIFO_DISPOSE
    /* toss from the front of the buffer till we have space */
    while (used+len+6 > BUFFER_SIZE) {
	clen = (B(head)<<8) | B(head+1);
	head = (head+4+clen)%BUFFER_SIZE;
	used -= (4+clen);
    }
#else
    /* toss expired packets to try make space */
    for (;;) {
	clen = (B(head)<<8) | B(head+1);
	stamp = (B(head+2)<<24) | (B(head+3)<<16) | (B(head+4)<<8) | B(head+5);
        if (stamp+BUFFER_TIMEOUT >= ctime)
	    break;
	head = (head+6+clen)%BUFFER_SIZE;
	used -= (6+clen);
    }
#endif
    if (used+len+6 <= BUFFER_SIZE) {
	used = used + 6 + len;
	B(tail) = (len>>8)&0xff;
	B(tail+1) = len&0xff;
	B(tail+2) = (ctime>>24)&0xff;
	B(tail+3) = (ctime>>16)&0xff;
	B(tail+4) = (ctime>>8)&0xff;
	B(tail+5) = ctime&0xff;
	tail = (tail+6)%BUFFER_SIZE;
	while (len--) {
	    buffer[tail] = *pkt++;
	    tail = (tail+1)%BUFFER_SIZE;
	}
    } else {
	syslog(LOG_ERR,
	    "Can't buffer packet of length %d, only %d bytes available.",
	    len,BUFFER_SIZE-(used+6));
    }
}

void forward_buffer()
{
    unsigned char pkt[4096];
    unsigned int clen, i;
    unsigned long stamp;
    unsigned long ctime = timestamp();
    struct sockaddr to;

    to.sa_family = AF_INET;
    strcpy(to.sa_data,snoop_dev);

    while (used > 0) {
	clen = (B(head)<<8) | B(head+1);
	stamp = (B(head+2)<<24) | (B(head+3)<<16) | (B(head+4)<<8) | B(head+5);
        if (stamp+BUFFER_TIMEOUT >= ctime) {
	    for (i = 0; i < clen; i++)
		pkt[i] = B(head+6+i);
	    if (sendto(fwdfd,pkt,clen,0,&to,sizeof(struct sockaddr)) < 0) {
		syslog(LOG_ERR,
	    	"Error forwarding data packet to physical device: %m");
	    }
	}
	head = (head+6+clen)%BUFFER_SIZE;
	used -= (6+clen);
    }
}

#endif
