.\" manual page [] for diald 0.9
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH DIALD 8 "DIALD 0.9 - 1995.07.16"
.SH NAME
diald \- demand dialing daemon for SLIP and PPP links
.SH SYNOPSIS
.B /usr/sbin/diald
device1 [devices2 ...] \fR[\fIoptions\fR...] [-- [\fIpppd options\fR...]]

.SH DESCRIPTION
.LP
Many sites use SLIP or PPP links to connect to other sites over
phone lines. Normally these links must be explicitly turned on or off.
.B diald
can be used to bring a SLIP or PPP link up when there are Internet packets
to be sent to another site, and to close the link down when it is idle.
.LP
.B diald
operates by starting a SLIP link on a pseudo tty and setting up a route
to the resulting interface. This interface is called the \fIproxy\fR.
.B diald
monitors the proxy to determine when to bring up a real communications
link. When a real link is up
.B diald
routes packets from the proxy to the real link and
monitors the real link to decide if it needs to be shut down.
As well, if the link goes down unexpectedly
.B diald
will attempt to reestablish the link.
The rules for controlling these operations are extensively configurable in
run time startup files.

.SH OPTIONS
Options may occur either on the command line, or in an
.I options file.
On startup
.B diald
reads options first from /etc/diald.defs, then from
/etc/diald.conf and then from the command line.
Additional options files may be specified on the command line.
The initial portion of the command line options must be
a list of one or more serial devices. Note that serial
devices can only be specified on the command line.
Any options after a "--" are options for
.B pppd
and are passed on to
.B pppd
whenever it is executed.
The /etc/diald.defs file is intended to contain only
.B var
and
.B prule
options, but this is not enforced.

Within options files options must appear one to a line.
Each line is parsed into a series of words delimited
by whitespace (space and tab characters).
Words can be quoted with (") to include whitespace in them.
Within a quoted word the sequence (\\") can be used
to enter a quote (") character.
Blank lines are ignored, as are lines where the first
non whitespace character is the (#) character.
.TP
.B -f \fI<f>
Read the file \fI<f>\fR for additional options.
.TP
.B -file \fI<f>
This is a synonym for the
.B -f
option.
.TP
.B -m \fI<m>
Set the operation mode to \fI<m>\fR.
Valid choices are:
.B slip\fR, \fBcslip\fR, \fBslip6\fR, \fBcslip6\fR, \fBaslip,\fR and \fBppp\fR.
.TP
.B mode \fI<m>
This is a synonym for the
.B -m
option.
.TP
.B accounting-log \fI<f>
Name the file that diald should append accounting information to.
This option allows diald to log connection start and end times
and the amount of data transferred during each connection.
This is intended to be used to aid company accounting departments
track phone usage.
.TP
.B pidfile \fI<f>
Changes the name of the file that diald uses to store its own PID
from diald.pid to the given file. This file is normally put into
the directory /var/run, although on some systems it will be
found in /etc.
.TP
.B fifo \fI<f>
Turns on the FIFO command channel. Diald will attempt to open a named pipe
with the pathname <f>. External programs can write commands to the pipe
and diald will react. See the section on signals and FIFO commands
below for the commands that can be issued to a running diald.
If the named pipe already exists diald will simply attempt to open it.
If it does not exist it will be created. Diald will create it
as owned by the user running diald (usually root) and with
permission modes "0600". Note that it is generally a bad idea
to allow too many users access to the control FIFO for diald.
Also, the best security is probably obtained by creating
the FIFO's ahead of time and choosing appropriate owners and permissons
rather than letting diald create them.
.TP
.B mtu \fI<m>
Set the MTU for the SLIP link to \fI<m>\fR. If you are using the PPP mode
you should set this relatively high. The default is 1500.
If you are using SLIP mode then this setting should match the
MTU setting required by your SLIP provider.
.TP
.B local \fI<a>
Sets the local IP address for the link established by
.B diald.
This option is not optional.
If you are not using the dynamic option then this address must
match the local IP address assigned to you by your provider.
.TP
.B remote \fI<a>
Sets the remote IP address for the link established by
.B diald.
This option is also not optional.
If you are not using the dynamic option then this address should
match the remote IP address of your provider. (Note that due
to the nature of IP routing this is not actually necessary,
but your routing tables will appear confusing to you if the
addresses don't match).
.TP
.B netmask \fI<a>
Set the netmask to be used for the interface.
.TP
.B dynamic
Dynamically change the local and remote IP addresses to match
those obtained when an actual connection (either SLIP or PPP)
is made. Note that in dynamic mode initial local and remote IP addresses must
still be specified, but it is not necessary that either address be correct.
.TP
.B dslip-mode \fI<mode>
Set the interpretation of dynamic address information for SLIP mode.
The possible settings are: \fBbootp\fR, \fBremote\fR, \fBlocal\fR,
\fBremote-local\fR, and \fBlocal-remote\fR.
If the mode is \fBbootp\fR, then the BOOTP protocol is
used to determine the dynamic slip address.
Otherwise dynamic slip addresses are determined by reading a banner
string that is produced by the remote SLIP server when it starts.
The string produced might be something like:
.IP
Annex address is 137.130.1.14. Your local address is 137.130.2.44.
.IP
The \fBdslip-mode\fR specifies which IP addresses should be
read from the servers initial output, and in which order they
will appear. The default mode is \fBremote-local\fR.
.TP
.B defaultroute
Tell
.B diald
to set up a default route to the SLIP link.
.TP
.B addroute \fI<script-name>
The designated script or executable
is called by \fBdiald\fR once it has established
the proxy device. The script is passed four arguments:
\fI<iface> <netmask> <local-ip> <remote-ip>\fR.
The \fI<iface>\fR argument designates the interface
that the proxy device is using, and the
remaining arguments give the current netmask,
local ip address and remote ip address of that interface.
Note that these values may be changed later when diald
actually makes a connection, but that this should not
affect any routing that is established for the designated
interface.
.TP
.B delroute \fI<script-name>
The designated script or executable
is called by \fBdiald\fR just before it deletes the
proxy device (when \fBdiald\fR is about to terminate).
The script receives the same arguments as the addroute script.
.TP
.B ip-up \fI<script-name>
The designated script or executable
is called by \fBdiald\fR whenever the IP layer is brought up.
The script receives the same arguments as the addroute script.
.TP
.B ip-down \fI<script-name>
The designated script or executable
is called by \fBdiald\fR whenever the IP layer is brought down.
The script receives the same arguments as the addroute script.
.TP
.B connect \fI<p>
Use the executable or shell script \fI<p>\fR to set up the
serial line. This normally dials the modem and starts up
the remote SLIP or PPP session. The
.B chat
program that comes with
.B pppd
serves this purpose well.
This option isn't really optional, as diald will refuse
to operate without a connect script.
.TP
.B disconnect \fI<p>
Use the executable or shell script \fI<p>\fR to shut down
serial line. This could be used to hang up the modem on
systems that don't do hardware hang-ups.
.TP
.B lock
Perform UUCP style locking of the modem when dialing in SLIP mode.
.TP
.B speed \fI<baud-rate>
Set the baud rate to use on the modem. This is ignored for PPP links.
The default value is 38400.
.TP
.B modem
Treat the serial device as a modem.
This option will also
be passed on to
.B pppd
in PPP mode.
.TP
.B crtscts
Use the RTS and CTS modem control lines when dialing/connecting.
This option will also
be passed on to
.B pppd
in PPP mode.
.TP
.B rotate-devices
In normal operation diald attempts to open each of the possible
devices listed on its command line in the order they are given.
If the first device on this fails in such a way that it can
still be opened, but it will not be able to connect (e.g.
someone tripped over the modem cable), then diald will not
be able to make a connection until the problem is corrected.
This option forces diald to rotate the list devices each time
a device is opened. Thus, in the above scenario diald would
fail to make the connection on the damanged device, but would
then try the second device first on the next attempt.
.TP
.B debug \fI<mask>
Set the debugging mask. See diald.h for the possible mask values.
A value of 0 turns off debugging output. Debugging is off by default.
.TP
.B -daemon
Don't run in daemon mode. This means that the
the standard input, standard output,
and standard error output are not closed, that all messages
are logged to the standard error as well as the syslog facility,
and that the diald program does not fork itself into the background.
This is mostly useful when you are running the debugging mode and
you want to see what is happening.
.TP
.B connect-timeout \fI<t>
Set the maximum amount of time to wait for the connect script to complete
to \fI<t>\fR seconds. The default is 60 seconds.
.TP
.B disconnect-timeout \fI<t>
Set the maximum amount of time to wait for the disconnect script to complete
to \fI<t>\fR seconds. The default is 60 seconds.
.TP
.B redial-timeout \fI<t>
Set the delay between dialing attempts to \fI<t>\fR seconds. The default is
30 seconds.
.TP
.B stop-dial-timeout \fI<t>
Set the maximum amount of time to wait for connect to die after
sending a SIGINT to \fI<t>\fR seconds. The default is 60 seconds.
.TP
.B kill-timeout \fI<t>
Set the maximum amount of time to wait for a subprocess to
die after sending a SIGKILL to \fI<t>\fR seconds. After
this diald will assume there is something permanently wedge
and terminate. (This should never happen). The default is 60 seconds.
.TP
.B start-pppd-timeout \fI<t>
Set the maximum amount of time to wait for
.B pppd
to choose
a PPP device to \fI<t>\fR seconds. The default is 60 seconds.
.TP
.B stop-pppd-timeout \fI<t>
Set the maximum amount of time to wait for
.B pppd
to die
after sending it SIGINT to \fI<t>\fR seconds. The default is 60 seconds.
.TP
.B first-packet-timeout \fI<t>
Set the first packet timeout to \fI<t>\fR seconds.
After the link has been established there may be some delay
before the first packet is actually sent, for example
while
.B pppd
negotiates the link parameters.
If no packets have crossed the link after \fI<t>\fR seconds
then
.B diald
will assume something went wrong and shut the link down.
The default timeout is 120 seconds.
.TP
.B retry-count \fI<n>
Set the maximum number of times diald should attempt to make the initial
connection without falling back and waiting for more network traffic.
The default is 0.
.TP
.B died-retry-count \fI<n>
Set the maximum number of times diald should attempt to restore a
connection that was severed before it should fall back and
wait for more network traffic.
The default is 1.
.TP
.B prule \fI<name> <protocol> <spec>
Define a new protocol rule called \fI<name>\fR to be used
in filter statements. The \fI<protocol>\fR field
must either be the name of a protocol defined in /etc/protocols,
the special keyword "any", or an integer between 0 and 254 inclusive.
The \fI<spec>\fR field is a list of 16 colon separated offset
codes that specify the bytes to be extracted from a packet
to build a \fIpacket identifier\fR.
Each offset code is an integer, possibly prefixed with a '+'.
Values that are not prefixed are offsets into the ip header,
values with the '+' prefix are offsets into the data segment
of the ip packet.
.TP
.B var \fI<name> <spec>
Define a new variable called \fI<name>\fR to be used in filter
statements. The \fI<spec>\fR portion of the definition
defines how to construct the value of the variable from a packet.
It consists of a byte offset to a 4 byte word, possibly prefixed with a '+', 
optionally followed by a right shift value in brackets,
optionally followed by a '&' character and a bit mask value.
Offsets prefixed with '+' are offsets into the data segment
of the ip packet, otherwise they are offsets into the ip header
of the packet. For example, the ip source address of a packet is
defined by
.IP
	var ip.saddr 12
.IP
which means to get the four bytes located starting at an
offset of 12 into the packet header.
Similarly, the ip protocol of a packet is defined by
.IP
	var ip.protocol 9(24)&0xff
.IP
which means to get the four bytes located starting at an
offset of 9 bytes into the header, right shift the obtained
value by 24 bits, and mask it with 0xff.
As a final example, the source port in a tcp header is defined as
.IP
	var tcp.source +0(16)&0xffff
.IP
which says to obtain the four bytes starting at the beginning
of the ip data segment, shift the value right by 16 bits,
and mask it with 0xffff.
.TP
.B accept \fI<protocol-rule> <timeout> <packet-rule>
Define a packet matching rule to control the link.
Packets that match an accept rule will cause the link to
come up and stay up for at least <timeout> seconds.
The \fI<protocol-rule>\fR must refer to a protocol rule defined
by a previous \fBprule\fR statement.
The value \fI<timeout>\fR must be a non negative integer.
A \fI<timeout>\fR of zero means the connection associated with
the packet will be killed immediately.
.IP
The \fI<packet-rule>\fR parameter is a list of one or
more conditions that the packet must meet.
As a special case the rule "any" matches all packets.
Otherwise, a rule is written as a list of terms,
separated by commas and no white space. Each term specifies
either a test on some field of the packet.
Basic terms are written as
.IP
	<variable-name><op><value>
.IP
or
.IP
	<variable-name>&<bitmask><op><value>
.IP
Where the <bitmask> is an optional binary bitmask to logical and with
the variable value before the comparison and <op> is one of
"=", "!=", "<=" or ">=".
As well there are two short forms:
"<variable-name>" and "!<variable-name>",
which are short for "<variable-name>!=0" and "<variable-name>=0".
.IP
Only variable names defined by previous \fBvar\fR statements
may be used in packet rules.
Comparison values and bitmask values can be specified
as decimal numbers, octal numbers, hex numbers, dots and numbers
style ip addresses, or by symbolic names.
The symbolic names of the form "tcp.<service>", "udp.<service>"
match the values defined in /etc/services.
Symbolic names can also match any protocol defined in /etc/protocols.
.IP
See the discussion on controlling link uptime below for further explanation
of how accept rules are applied.
.TP
.B bringup \fI<protocol-rule> <timeout> <packet-rule>
Define a packet matching rule to control the link.
Packets that match a bringup rule will cause attempts to bring the
link up for at least <timeout> seconds.
These rules are ignored if the link is currently up.
The parameters are exactly as described for the accept command.
.IP
See the discussion on controlling link uptime below for further explanation
of how bringup rules are applied.
.TP
.B keepup \fI<protocol-rule> <timeout> <packet-rule>
Define a packet matching rule to control the link.
Packets that match a keepup rule will cause the link to stay
up, if it is already up, for at least <timeout> seconds.
These rules are ignored if the link is currently down.
The parameters are exactly as described for the accept command.
.IP
See the discussion on controlling link uptime below for further explanation
of how keepup rules are applied.
.TP
.B ignore \fI<protocol-rule> <packet-rule>
Define a packet matching rule to control the link.
Packets that match an ignore rule will be ignored and
will not match any later rules.
Except for the lack of a <timeout> parameter,
the parameters are exactly as described for the accept command.
.IP
See the discussion on controlling link uptime below for further explanation
of how ignore rules are applied.
.TP
.B restrict \fI<start> <end> <weekdays> <monthdays> <months>
.TP
.B or-restrict \fI<start> <end> <weekdays> <monthdays> <months>
Normally filter rules apply at all times. The restrict statement
makes all filter rules following the restrict statement, up
to the next restrict statement, apply only at the times indicated
by the restrict statement. A restrict statement provides five numeric
fields. The first two fields indicate a starting time and an ending
time, given in the form "HH:MM:SS". If "*" is given for the
start time it is taken as meaning "00:00:00". Similarly
if "*" is given for the end time it is taken as meaning "23:59:59".
For the remaining three fields, each field is either "*",
to indicate all possible values, or a comma separated list
of numbers and number ranges.
The \fI<weekdays>\fR field specifies the days of the week
Acceptable numbers are in the range 0-6, where the number 0
is Sunday, the number 1 is Monday, and so forth.
The \fI<monthdays>\fR field specifies the days of the month.
Acceptable numbers are in the range 1-31.
The \fI<months>\fR field specifies the months of the year.
Acceptable numbers are in the range 1-12.
A restrict command specifies an range of times.
The or-restrict command expands the immediately preceeding restrict
to include the range of times specified by the or-restrict command.
As an example, to restrict the following filter rules to
be applicable from 2-3 AM and 5-6 PM every Sunday one
would use the statements:
.IP
	restrict 2:00:00 3:00:00 0 * *
.br
	or-restrict 17:00:00 18:00:00 0 * *
.IP
WARNING: this interface is expiremental and the syntax may change in future 
versions of diald.
.TP
.B up
The up rule forces the link to be up at all times, regardless of
the packet filtering that is in force. The application of this rule
can be limited by the use of a restrict statement.
For example, the sequence of options
.IP
	restrict 12:00:00 13:00:00 * * *
.br
	up
.IP
would force the link to be up from 12:00-1:00 PM every day.
.TP
.B down                           
The down rule forces the link to be down at all times, regardless
of the packet filtering that is in force. The application of this
rule can be limited by the use of a restrict statement.
For example, the sequence of options
.IP
	restrict 12:00:00 13:00:00 * * *
.br
	down
.IP
would force the link to be down from 12:00-1:00 PM every day.
.IP
NOTE: Up and down rules with overlaping restrictions are applied
in the order they are given. For example, The sequence
.IP
	restrict 12:30:00 12:39:00 * * *
.br
	down
.br
	restrict 12:00:00 13:00:00 * * *
.br
	up
.IP
would bring the link up at 12:00 PM, bring it back down at
12:30, back up at 12:40, and let the line float up or down
depending upon traffic after 1:00 PM.
.TP
.B impulse \fI<duration>,<fuzz>
.TP
.B impulse \fI<initial-duration>,<secondary-duration>,<fuzz>
The impulse command is used to control the link up time in
units larger than a single second. This is intended to be
used in areas where phone connections are charged in impulses.
In the two argument form, the \fI<duration>\fR
parameter indicates the number of seconds that diald will
keep the line up before checking to see if it is idle.
The \fI<fuzz>\fR parameter is the number of seconds that diald
will continue to monitor the idle state before waiting
for \fI<duration>\fR seconds again.
In the three argument form, the \fI<initial-duration>\fR
parameter indicates the minimum number of seconds diald will keep the
line up once a call has been initiated. After this timer expires
diald will proceed as for the two argument case using the
\fI<secondary-duration>\fR parameter in place of the \fI<duration>\fR
parameter.  Zero values for \fI<duration>\fR and
\fI<fuzz>\fR turn off the impulses feature.

For example, if on Sundays your phone connections are charged
in units of $1 per 1 hour chunk, and no matter how much of
each chunk you use you pay the full $1, then you might as well
keep the connection up for 1 hour once you've made it.
To accomplish this you might use the following commands.
.IP
	restrict * * 0 * *
.br
	impulse 3570 30
.IP
This will keep the link up for 3570 seconds at a time, with a 30 second
leeway to account for the time required to make and break the connection.
Note that the \fI<fuzz>\fR factor should not be made to small, since otherwise
diald may not be able to hang up the connection before your call is
being billed in the next impulse.

Similarly, if you're calls are billed by the second, but there is a
minimum charge for the first 10 minutes, then you might use the
following command.
.IP
	impulse 600,0,0
.TP
.B flushfilters
Remove all existing filter rule definitions.
.TP
.B flushprules
Remove all existing protocol rule definitions.
.TP
.B flushvars
Remove all existing variable definitions.

.SH PPPD OPTIONS
When \fBdiald\fR is being used in PPP mode extra options can b
 passed on to
.B pppd
by specifying them after a "--" on the command line.
This should not normally be necessary as default options can
be placed into the /etc/ppp/options file. But, if you need
to run multiple instances of pppd with different options
then you will have to make use of this ability. \fB Note that
some pppd options should not be specified, not
even in the /etc/ppp/options file, because they will interfere
with the proper operation of diald.\fR
In particular you should not specify
the tty device, the baud rate, nor any of the options
\fBcrtscts\fR, \fBxonxoff\fR, \fB-crtscts\fR, \fBdefaultroute\fR,
\fBlock\fR, \fBnetmask\fR, \fB-detach\fR,
\fBmodem\fR, \fBlocal\fR, \fBmtu\fR and \fBproxyarp\fR.
Use the equivalent diald options to control these pppd settings.
Note that there is not yet a diald option to directly do 
proxyarp routing. You must use the "addroute" and "delroute" scripts
to accomplish this.

.SH MULTIPLE DEVICES
If you specify more than one device on the command line diald
will use them as a list of devices to search for a free device.
When attempting to establish an outside connection it will try
each device in turn until it finds one that is not locked.
it will then attempt to dial out on that device. If it fails
to dial out it will relinquish its lock and go through the
device list again the next time it tries to establish the connection.

.SH SIGNALS AND FIFO COMMANDS
A running copy of diald can be controled externally in two ways.
The simplist way is to send it signals. This is by necessity somewhat
limited. If it is necessary to send more complex commands to diald
the
.B fifo
option can be used.

.B Diald
can be controlled by the following signals.
.TP
.B SIGINT
Force the link down. Diald continues to run.
.TP
.B SIGTERM
Shut down the link and terminate diald.
.TP
.B SIGUSR1
Force the link up.
.TP
.B SIGUSR2
Dump the filter queue to syslog.
.LP
If the
.B fifo
option is used, then additional commands can be issued to diald as follows.
Say the option "fifo /etc/diald.fifo" is given to diald.
Programs can write the following commands to /etc/diald.fifo, which
will then be acted upon by diald.
.TP
.B block
Block diald from making outgoing calls until a unblock command is issued.
If the link is up this will also force it down.
.TP
.B unblock
Remove a block on diald making outgoing calls.
.TP
.B down
Force the link down.
.TP
.B up
Force the link up.
.TP
.B debug \fI<flags>
Set the debug flags to the given value.
.TP
.B delay-quit
Terminate diald as soon as the link next goes idle.
.TP
.B quit
Force the link down and terminate diald.
.TP
.B queue
Print the contents of the filter queue to the syslog.
.TP
.B connect \fI<pid> <device>
If diald is not currently up, then force it to come up and
make a connection on the specified device. Diald will open
the named device, ignoring the device specified on the
diald command line, skip running the "connect" script,
and attempt to run either SLIP or PPP directly.
This is intended to be used to rendezvous with incoming calls.
When diald closes the connection to <device>
it will send SIGKILL to <pid>. Normally this will be the
program that issued the connect command to diald,
which will be waiting to be killed to terminate a login.
.SH COMMAND LINE EXAMPLES
.LP
\."WRITE ME! (REWRITE!!!!)
\."Do, slip and dynamic slip. Do PPP and dynamic PPP.
\."Talk about multiple diald's. Talk about IP address concerns.

The simplest use of diald is to establish a SLIP or PPP connection
to a remote site that is the sole external network connection.
Suppose you want to establish a dial on demand link to a remote
site with the ip address 137.130.1.14, and that your site
is assigned the address 137.130.2.44.

Assuming that /etc/pppchat is a
.B chat
script that dials up your remote site and places the remote
end of the connection into PPP mode, then you can run diald
in PPP mode as follows:
.IP
diald /dev/cua1 -m ppp local 137.130.1.14 \\
.br
   remote 137.130.2.44 defaultroute modem crtscts \\
.br
   connect "chat -f /etc/pppchat"
.LP
Similarly if /etc/slipchat is a
.B chat
script that dials up your remote site and places the remote
end of the connection into SLIP mode, then you can run diald
in SLIP mode as follows:
.IP
diald /dev/cua1 -m slip local 137.130.1.14 \\
.br
   remote 137.130.2.44 defaultroute modem crtscts \\
.br
   connect "chat -f /etc/slipchat" mtu 296
.LP
To minimize the length of command lines you can place most
of these options into your /etc/diald.conf file.
In both cases diald will establish a default route to the
remote site, and any packets originating from your site
will be given a source address of 137.130.1.14.
.LP
Let us consider a slight complication of the above scenario.
Assume now that when you dial your remote site you might
be connected to any one of a number of terminal servers,
each of which has a different remote address. What should
you pick for the remote address on the diald command line?
Curiously enough, it doesn't matter. The remote address assigned
to an interface is really only a local label that the route
program uses to find the right interface. Once the routes
have been established the number is never used again.
Therefore, faced with the above situation we might issue
the command:
.IP
diald /dev/cua1 -m ppp local 137.130.1.14 \\
.br
   remote 127.0.0.2 defaultroute modem crtscts \\
.br
   connect "chat -f /etc/pppchat"
.LP
Let us again complicate matters for ourselves. Assume now
that not only do you not know the remote address you will
get connected to, but that the remote site might assign you
a different local address each time you connect. In this situation
we must use the \fBdynamic\fR option. Note that you must
still supply an initial local address, otherwise diald
won't be able to fake the existence of a connection when
none has yet been made. If you are using PPP then you might
simply issue the command:
.IP
diald /dev/cua1 -m ppp local 127.0.0.3 \\
.br
   remote 127.0.0.2 defaultroute modem crtscts \\
.br
   connect "chat -f /etc/pppchat" dynamic
.LP
Note that you must initially lie about the local address.
You should be careful not to specify an address that is
assigned to an actual connection.

If you are using SLIP things are slightly more complicated.
This is because the SLIP protocol does not specify a way
for the two machines to negotiate the addresses assigned
to the endpoints. The standard way to get around this problem
is to have the remote SLIP server output a string stating
the addresses that have been assigned before it actually
goes into SLIP mode. The local machine can then read these
strings from the modem before it enters SLIP mode.
.B Daild
is capable of reading and interpreting these strings, but
it needs a little help. In particular, diald can't know in
advance which order the local and remote addresses will be
output, or for that matter if both will even appear.
The \fBdslip-mode\fR option allows you to specify what
address should be expected to appear and what
order they will appear in.
For example, if your remote site prints out the
remote address followed by the local address
(possibly with some intervening text between the addresses),
the you might issue the following command:
.IP
diald /dev/cua1 -m slip local 127.0.0.3 \\
.br
   remote 127.0.0.2 defaultroute modem crtscts \\
.br
   connect "chat -f /etc/slipchat" mtu 296 \\
.br
   dynamic dslip-mode remote-local
.LP

.SH CONTROLLING LINK UPTIME
.LP
.B Diald
maintains a virtual link to the remote site
at all times. This link is in one of two modes.
Either the corresponding physical link is expected to be up,
or it is expected to be down.
When the physical link is expected to be up
.B diald
will attempt to maintain
the physical link, dialing and re-dialing if necessary.
It will also monitor any packets passing over the virtual
link to determine if the physical link should be brought down.
When the physical link is expected to be down
.B diald
will monitor packets that are sent to the virtual link to determine
if the physical link should be brought up.
The general approach used by
.B diald
to determine when to change between these two modes is to
keep a \fIconnection set\fR of \fIconnection identities\fR,
each with an associated timeout.
When a timeout associated with a connection identity
expires, it is removed from the set.
When the connection set is empty
.B diald
expects the physical link to be down,
otherwise
.B diald
expects the physical link to be up.
.LP
Accept, bringup, keepup and ignore rules control the addition of new connection
identities to the connection set. Each accept, bringup or keepup rule specifies
a set of conditions that a packet must match, a method
to generate a connection identity from a packet, and a timeout.
Ignore rules specify only a set of conditions that a packet must match.
When a packet arrives that matches a given accept rule, then
a connection identity, say \fI<id>\fR, is generated from the packet,
and \fI<id>\fR is added to the connection set with the
timeout specified by the filter rule. If \fI<id>\fR was already
in the set, then the new timeout will replace the old timeout.
Note that the new timeout may be less than the old timeout.

Each accept, bringup, keepup or ignore statement must specify the name of a
protocol rule.
Protocol rules specify how to build connection identifiers.
The distributed /etc/diald.defs file contains the following
four definitions:
.LP
prule tcp tcp 9:12:13:14:15:16:17:18:19:+0:+1:+2:+3:9:9:9
.br
prule udp udp 9:12:13:14:15:16:17:18:19:+0:+1:+2:+3:9:9:9
.br
prule icmp icmp 9:12:13:14:15:16:17:18:19:9:9:9:9:9:9:9
.br
prule any any 9:12:13:14:15:16:17:18:19:9:9:9:9:9:9:9
.LP
The tcp and udp rules respectively match tcp and udp packets,
and build connection identifiers consisting of the packet protocol,
the source and destination IP addresses, and the source
and destination port numbers.
The icmp and any rules construct identifiers consisting only
of the packet protocol and source and destination IP addresses.
.LP
As well, each accept, bringup, keepup or ignore statement must specify some
set of conditions on the contents of the packet. Variable
definitions allow access to the contents of the packet in
accept and reject statements.
The distributed /etc/diald.defs file defines
variables for all the fields in the ip packet header
and for all the fields in the tcp, udp and icmp packet headers.
The names match those used in the 
include files found in /usr/include/linux.
.LP
The IP packet header variables are:
    ip.ihl			header length
.br
    ip.version			format version
.br
    ip.tos			type of service
.br
    ip.tot_len			length of ip packet in words
.br
    ip.id				packet id
.br
    ip.frag_off		fragment offset
.br
    ip.ttl			time to live
.br
    ip.protocol		ip protocol
.br
    ip.check			ip header checksum
.br
    ip.saddr			ip source address
.br
    ip.daddr 			ip destination address
.LP
The TCP packet header variables are:
    tcp.source			tcp source port
.br
    tcp.dest			tcp destination port
.br
    tcp.seq			tcp sequence number
.br
    tcp.ack_seq		tcp ack sequence number
.br
    tcp.doff			tcp data offset in words
.br
    tcp.fin			tcp finish flag
.br
    tcp.syn			tcp synchronize flag
.br
    tcp.rst			tcp reset flag
.br
    tcp.psh			tcp push flag
.br
    tcp.ack			tcp acknowledge flag
.br
    tcp.urg			tcp urgent flag
.LP
The UDP packet header variables are:
    udp.source			udp source port
.br
    udp.dest			udp destination port
.br
    udp.len			udp header length
.br
    udp.check			udp packet checksum
.LP
The ICMP packet header variables are:
    icmp.type			icmp packet type
.br
    icmp.code			icmp packet code
.br
    icmp.checksum		icmp packet checksum
.br
    icmp.echo.id		icmp echo id
.br
    icmp.echo.sequence	icmp echo sequence
.br
    icmp.gateway		icmp gateway
.LP
It may help to consider some examples.
The rule
.IP
accept tcp 10 any
.LP
says to match any tcp packet and assign the generated
connection identity a timeout of 10 seconds.
The method used to generate a connection identity is specific
to tcp packets. The identity of a tcp packet consists of
the protocol, the source and destination ip address, and
the source and destination port associated with the tcp packet.
.LP
Similarly, the rule
.IP
accept any 10 any
.LP
says to match any packet and assign the generated connection
identity a timeout of 10 seconds.
.LP
The rule
.IP
accept tcp 60 tcp.dest=tcp.www,ip.daddr&255.255.0.0=149.100.2.45
.LP
matches any tcp packet with a destination matching the tcp www
port number specified in /etc/services, and an ip destination
address on the 149.100.0.0 subnet.
.LP
For further examples look at the distributed /etc/diald.conf file.
.SH DIAGNOSTICS
.LP
Exits with status 1 if something causes diald to terminate
abnormally.
Error and information messages are logged to the syslog daemon
under the LOCAL2 facility. If diald is not running in daemon
mode, then they are also printed on stderr.
Setting the debugging mask flags can greatly increase the amount
of this output. If you turn debugging on watch your log files!
.SH FILES
.TP
/etc/diald.conf
Default options file.
.TP
/etc/diald.defs
Default protocol rules and variable definitions.
.TP
/var/lock/LCK..*
UUCP style lock files for serial devices.
.TP
/var/run/*
Logging for the pid of a running diald. By default the file
diald.pid is used. This can be changed with the pidfile option.

.SH SEE ALSO
.LP
pppd (8), chat(8), dip(8)

.SH AUTHOR
.LP
Eric Schenk (schenk@cs.toronto.edu)
.SH BUGS AND LIMITATIONS
.LP
There are some known problems and limitations.
.LP
Lines in options files can contain at most 1024 characters.
Longer lines are silently truncated.
.LP
If there are no filter rules specified then no packets will
be matched and the daemon won't do anything. It should
probably match all packets by default in this case.
.LP
Diald's support for multiple modem devices is somewhat
limited. It will try a list of devices, but it uses
the same chat script and control settings on all
the devices. This means that you must have the  
same kind of modem on every device. At some point diald
needs a better way to configure individual devices for call out
in an independent way.
.LP
Diald has no way of automatically adjusting the MTU of the proxy
to match the MTU of the actual connection negotiated by ppp.
If these values do not match then long packets will be dropped on the floor.
You must match these values manually. Use ifconfig to find out what
MTU was negotiated by ppp once the link comes up.
