/*
 * ppp.c - ppp and pppd control.
 *
 * Copyright (c) 1994 Eric Schenk.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
 * SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include "diald.h"
#ifdef PPP_VERSION_2_2_0
#include <linux/ppp_defs.h>
#include <linux/if_ppp.h>
#else
#include <linux/ppp.h>
#endif

void ppp_start()
{
    int pgrpid;

    link_iface = -1;
    /* Run pppd directly here and set up to wait for the iface */
    link_pid = fork();

    if (link_pid < 0) {
	syslog(LOG_ERR, "failed to fork pppd: %m");
	die(1);
    }

    if (link_pid == 0) {
	char **argv = (char **)malloc(sizeof(char *)*(pppd_argc+7));
	int i = 0, j;;

	argv[i++] = PATH_PPPD;
	argv[i++] = "-detach";
	if (modem) argv[i++] = "modem";
	if (crtscts) argv[i++] = "crtscts";
	if (netmask) {
	    argv[i++] = "netmask";
	    argv[i++] = netmask;
	}
	for (j = 0; j < pppd_argc; j++)
	    argv[i++] = pppd_argv[j];
	argv[i++] = 0;

	/* make sure pppd is the session leader and has the controlling
         * terminal so it gets the SIGHUP's
         */
	pgrpid = setsid();
        ioctl(modem_fd, TIOCSCTTY, 1);
	tcsetpgrp(modem_fd, pgrpid);

	setreuid(getuid(), getuid());
	setregid(getgid(), getgid());

	dup2(modem_fd, 0);
	dup2(modem_fd, 1);

	execv(PATH_PPPD,argv);

	syslog(LOG_ERR, "could not exec %s: %m",PATH_PPPD);
	_exit(99);
	/* NOTREACHED */
    }
    syslog(LOG_ERR,"Running pppd (pid = %d).",link_pid);
}

/*
 * SET_SA_FAMILY - set the sa_family field of a struct sockaddr,
 * if it exists.
 */

#define SET_SA_FAMILY(addr, family)                     \
    memset ((char *) &(addr), '\0', sizeof(addr));      \
    addr.sa_family = (family);

/*
 * Find the interface number of the ppp device that pppd opened up and
 * do any routing we might need to do.
 * If pppd has not yet opened the device, then return 0, else return 1.
 */

int ppp_set_addrs()
{
    ulong laddr = 0, raddr = 0;

    /* Try to get the interface number if we don't know it yet. */
    if (link_iface == -1) ioctl(modem_fd, PPPIOCGUNIT, &link_iface);

    /* Ok then, see if pppd has upped the interface yet. */
    if (link_iface != -1) {
	struct ifreq   ifr; 

	SET_SA_FAMILY (ifr.ifr_addr,    AF_INET); 
	SET_SA_FAMILY (ifr.ifr_dstaddr, AF_INET); 
	SET_SA_FAMILY (ifr.ifr_netmask, AF_INET); 
	sprintf(ifr.ifr_name,"ppp%d",link_iface);
	if (ioctl(snoopfd, SIOCGIFFLAGS, (caddr_t) &ifr) == -1) {
	   syslog(LOG_ERR,"failed to read ppp interface status");
	   return 0;
	}
	if (!(ifr.ifr_flags & IFF_UP))
	    return 0;	/* interface is not up yet */

	/* Ok, the interface is up, grab the addresses. */
	if (ioctl(snoopfd, SIOCGIFADDR, (caddr_t) &ifr) == -1)
		syslog(LOG_ERR,"failed to get ppp local address: %m");
	else
       	    laddr = ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

	if (ioctl(snoopfd, SIOCGIFDSTADDR, (caddr_t) &ifr) == -1) 
	   syslog(LOG_ERR,"failed to get ppp remote address: %m");
	else
	   raddr = ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

	if (dynamic_addrs) {
	    /* only do the configuration in dynamic mode. */
	    struct in_addr addr;
	    addr.s_addr = raddr;
	    strcpy(remote_ip,inet_ntoa(addr));
	    addr.s_addr = laddr;
	    strcpy(local_ip,inet_ntoa(addr));
	    local_addr = laddr;
	    syslog(LOG_INFO,"New addresses: local %s, remote %s.",
		local_ip,remote_ip);
	    proxy_config(local_ip,remote_ip);
#ifndef UNSAFE_ROUTING
	    add_routes("sl",proxy_iface,local_ip,remote_ip);
#endif
	}

#ifdef UNSAFE_ROUTING
	add_routes("ppp",link_iface,local_ip,remote_ip);
#endif
	return 1;
    }
    return 0;
}

int ppp_dead()
{
    if (link_pid == 0) {
	/* pppd is way too enthusiastic about deleting routes it had
	 * nothing to do with creating. Therefore, we have to reestablish
	 * the proxy routes here, including the point to point route!
	 */
	set_ptp("sl",proxy_iface,orig_remote_ip);
	add_routes("sl",proxy_iface,orig_local_ip,orig_remote_ip);
    	local_addr = inet_addr(orig_local_ip);
    }
    return (link_pid == 0);
}

void ppp_stop()
{
    if (link_pid) kill(link_pid,SIGINT);
}

void ppp_reroute()
{
    /* Restore the original proxy routing */
    proxy_config(orig_local_ip,orig_remote_ip);
    set_ptp("sl",proxy_iface,orig_remote_ip);
    add_routes("sl",proxy_iface,orig_local_ip,orig_remote_ip);
    local_addr = inet_addr(orig_local_ip);
#ifdef UNSAFE_ROUTING
    /* If we did routing on the ppp link, remove it */
    if (link_iface != -1)
    	del_routes("ppp",link_iface,local_ip,remote_ip);
#endif
    link_iface = -1;
}

void ppp_kill()
{
    if (link_pid) kill(link_pid,SIGKILL);
}
