.TH SLIRP 1 "22 Mar 1995"
.SH NAME
slirp \- a SLIP/CSLIP emulator
.SH SYNOPSIS
slirp [-h] [-b BAUDRATE] [-c] [-d FILE] [-D DELAY] [-f FILE] [-m MTU] \
[-s] [-x N] [-X ADDR]
.SH DESCRIPTION
.PP
.I SLiRP
is a SLIP/CSLIP emulator which allows a normal user with a shell
account on a UNIX system to act like a SLIP/CSLIP account.
.SH OPTIONS
.PP
.IP "\fB-h\fP"
Show usage.
.IP "\fB-b BAUDRATE\fP"
Set the baudrate (default 9600).
.IP "\fB-c\fP"
Do compression (CSLIP).
.IP "\fB-d FILE\fP"
Write debugging info to FILE.
.IP "\fB-f FILE\fP"
Read FILE as a configuration file.
.IP "\fB-m MTU\fP" 
Set the MTU of the link (default 552).
.IP "\fB-s\fP"
Print statistics on exit.
.IP "\fB-x N\fP"
Set N as the control network class (set to -1 to disable control
commands).
.IP "\fB-X ADDR\fP"
Only allow packets from ADDR to use CTL.
.SH CONFIGURATION
.PP
At startup, SLiRP will read the file ~/.slirprc if it exists.  The following
configuration options are currently recognised:

redir tcp PORT HOST:LPORT

- Redirect PORT to HOST:LPORT.  If PORT is 65535, then SLiRP will
redirect any port it gets to HOST:LPORT, and tell you on startup of
the PORT it received.  

baudrate N

- Set baudrate to N.  Note, this code is still a little sketchy.  If
you're not getting maximum throughput, set this to a value much
greater than the actual baudrate (this will effectively disable this
code, but your interactive sessions will have much greater lag) 

compress

- Do CSLIP compression (by default, SLiRP will detect whether CSLIP
is used or not) 

nocompress

- Don't do CSLIP compression.

delay N

- Put a delay in the main loop to cut down CPU usage.  The way it is
now, SLiRP uses very little CPU so this may not ever be needed. 

mtu N

- Set the MTU to N.

control address HOST

- Only allow control-commands from HOST.

host address HOST

- Tell SLiRP the IP number of the host SLiRP is running on.  If SLiRP
reports the wrong IP address of the host it's running on at startup,
or SLiRP warns you about not being able to figure out the IP number,
you must supply this parameter or some programs will not work. 

[and possibly others, check the sources]

.SH CONTROLLING SLIRP USING TELNET
.PP
Redirection (and other misc. config stuff) can be done on the fly by
telneting to a specific address.

[need to update]

.SH NOTES
.PP
To quit SLiRP you simply kill your SLIP/CSLIP software then send 5 0's
(zeros) down the line, with a 1 second pause between each. 

The code to try and "guess" how much it can write to the modem is
flakey. If you see that your modem isn't being used at it's maximum
capacity (eg: an ftp session to the remote-host, the modem's RECEIVE
light is not shining brightly all the time), you might want to
increase the baudrate by using the -b BAUDRATE command-line option.
If you choose a number which is far greater than the actual baud
rate, SLiRP will write to the modem as fast as the OS allows, hence
you'll get the maximum bandwidth. However, there will be a noticeable
increase in lag for interactive data (eg: a telnet session). 

SLiRP was written in an xterm which is 110x35 characters in size.  I
just had a look at portions of the source through an 80x25 character
console.  It is NOT pretty! :)  Apologies to the xterm-deficient. 

You can choose any IP you wish for your home machine, except the
following: 

- Any weird IP address which has some meaning to IP, like
255.255.255.255, 0.0.0.0, 127.0.0.1 (in fact, all 127.xxx.yyy.zzz),
etc., etc. 
.SH BUGS
.PP
SLiRP seems unstable on NetBSD, and I suspect Linux/FreeBSD as
well. Since I don't have access to a remote machine running any of
these OS's, I can't thoroughly test it and find out what's causing
this (or if the crashes were related to SLiRP).  It seems fairly
stable on Solaris ... 

Sometimes a session will spontaneously close.  I'm not exactly sure
how to *definitely* detect the closing of a non-blocking socket.  At
the moment, if the readv()/writev() returns 0, I assume it closed (why
else would a non-blocking socket be select()ed for reading then return
0?) 
.SH INCOMPATIBILITIES
.PP
Which programs do not work over SLiRP?

Any programs that bind() a port, then tell the other end of the
connection where they should connect() to this bound port.

For example: when you "get" a file during an ftp session, the ftp
client bind()'s a socket, has a look at which port the socket is bound
to, then tells the ftp server the address and port of this socket
(with the PORT command). The ftp server then connect()'s to this
address/socket pair. 

Now, since your machine isn't really on the Internet, this connect()
request will not arrive to your host, so it will not work.

SLiRP emulates this by bind()ing it's own port on the server that *is*
on the internet, and tells the ftp server about *that* address/socket
pair. When the server connect()'s to it, SLiRP will then connect back
to your machine.

Currently, ftp (PORT) and irc (DCC SEND and DCC CHAT) are emulated,
since these are the only programs I use which require this emulation.

If you have a program that does not work with SLiRP, you can do one of
2 things:

-  Find out the format of the "command" and write the code to do a
similar type of translation as is currently done by SLiRP.  See the
functions  tcp_emu() and tcp_tos() to see how this is done. 

- If you can't do the above, and you have the sources to the program,
you can recompile it with XXX included in the SLiRP package (XXX
actually, I haven't written this yet..)

.SH SEE ALSO
.PP
Documentation for tia and term.
.SH AUTHOR
.PP
danjo@blitzen.canberra.edu.au

