#ifndef __COMMON_H__
#define __COMMON_H__

#define VERSION "v0.9m ALPHA"

#include <config.h>
#include <sys/types.h>
#ifdef HAVE_SYS_BITYPES_H
#include <sys/bitypes.h>
#endif

#ifdef NEED_TYPEDEFS

#if SIZEOF_CHAR == 1
typedef char int8_t;
typedef u_char u_int8_t;
#else
 #error sizeof(char) != 1
#endif

#if SIZEOF_SHORT == 2
typedef short int16_t;
typedef u_short u_int16_t;
#else
# if SIZEOF_INT == 2
typedef int int16_t;
typedef u_int u_int16_t;
# else
 # error Cannot find a type with sizeof() == 2
# endif
#endif

#if SIZEOF_SHORT == 4
typedef short int32_t;
typedef u_short u_int32_t;
#else
# if SIZEOF_INT == 4
typedef int int32_t;
typedef u_int u_int32_t;
# else
 # error Cannot find a type with sizeof() == 4
# endif
#endif

#endif /* NEED_TYPEDEFS */

#if SIZEOF_CHAR_P != 8
#define insque_32 insque
#define remque_32 remque
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdio.h>
#include <errno.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include <sys/uio.h>

#ifndef NO_PROTOTYPES
#  define   _P(x)   x
#else
#  define   _P(x)   ()
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include "mbuf.h"
#include "sbuf.h"
#include "debug.h"
#include "if.h"

#ifndef NULL
#define NULL (void)0
#endif

#ifdef BAD_SPRINTF
#define sprintf sprintf_len
#ifdef __STDC__	/* can't rely on _P() if it has prototypes but isn't ANSI */
extern int sprintf_len _P((char *string, const char *format, ...));
#else
extern int sprintf_len();
#endif
#endif

#ifdef DECLARE_SPRINTF
#ifndef BAD_SPRINTF
extern int sprintf _P((char *, const char *, ...));
#endif
extern int fprintf _P((FILE *, const char *, ...));
#endif

#ifndef HAVE_STRERROR
extern char *strerror _P((int error));
#endif

int cksum _P((register struct mbuf *,register int));

extern int do_echo;

inline void insque _P((void *, void *));
inline void remque _P((void *));
#if SIZEOF_CHAR_P == 8
inline void insque_32 _P((void *, void *));
inline void remque_32 _P((void *));
#endif

#endif
