#ifndef _IF_H_
#define _IF_H_

struct ifp {
	int ifp_flags;				/* Misc flags, see below */
	void (*ifp_input) _P((void));			/* if input routine */
	void (*ifp_output) _P((struct socket *,struct mbuf *));	/* if output routine */
	void (*ifp_start) _P((void));			/* Start outputting */
	int (*ifp_encap) _P((char *, struct mbuf *));	/* Encapsulation routine */
	int ifp_mtu;				/* Maximum transfer unit of if */
	int ifp_maxlinkhdr;			/* Max link hdr size */
};

#define IF_COMPRESS	0x01	/* We want compression */
#define IF_NOCOMPRESS	0x02	/* Do not do compression */
#define IF_AUTOCOMP	0x03	/* Autodetect (default) */

extern struct ifp ifp;
extern int	if_inpkt;	/* Flag to indicate we're still reading a packet */
extern int	if_n;		/* Bytes left in interface input buffer */
extern int	if_esc;		/* Flag that we received an FRAME_ESC */
extern int	esc;		/* Number of times '0' has been hit (for quitting slirp) */
extern struct	mbuf *if_m;	/* mbuf we're transferring the packet to */
extern int	if_msize;	/* Size of mbuf we're transferring the packet to */
extern u_int8_t	*if_mptr;	/* Pointer into the mbuf we're writing to */
extern u_int8_t	*if_bptr;	/* Pointer to the if_inbuff we're reading from */
extern int	if_queued;	/* Number of packets queued so far */
extern int	if_thresh;	/* Number of packets queued before we start sending
				 * (to prevent allocing too many mbufs) */

extern	struct mbuf if_fastq;                  /* fast queue (for interactive data) */
extern	struct mbuf if_batchq;                 /* queue for non-interactive data */
extern	struct mbuf *next_m;

#define ifs_init(ifm) ((ifm)->ifs_next = (ifm)->ifs_prev = (ifm))

void if_output _P((struct socket *, struct mbuf *));
void if_start _P((void));

#endif
