#include "misc.h"

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#define TOWRITEMAX 512
#define min(x,y) ((x) < (y) ? (x) : (y))

extern struct timeval tt;
extern int ttyfd;
extern int idle_sec;

/*
 * Get the difference in 2 times from updtim()
 * Allow for wraparound times, "just in case"
 * x is the greater of the 2 (current time) and y is
 * what it's being compared against.
 */
#define TIME_DIFF(x,y) (x)-(y) < 0 ? ~0-(y)+(x) : (x)-(y)

extern char *exec_shell;
extern int towrite;
extern u_int curtime;
extern struct fd_set readfds, writefds, xfds;
extern u_int32_t ctl_addr;
extern u_int32_t special_addr;
extern u_int32_t our_addr;
extern int bytesps;
extern int baud;
extern char *username;

