/*
 * Startppp
 *
 * Copyright (C) 1995  Matthias Ott 
 *  (msott@cip.informatik.uni-erlangen.de)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
 
#include "tk.h"

#include "Time.h"
#include "Modem.h"

/*
   **	Function name : Startppp_Init
   **
   **	Description : creates the new commands
   **	Input :
   **	Output :
*/
int Startppp_Init(Tcl_Interp *interp)
{
  Tcl_CreateCommand (interp, "gettime", GetTime, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "getshowtime", GetShowTime, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "onlineshowtime", OnlineShowTime, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "showdifftime", ShowDiffTime, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "getpartzone", GetPartZone, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "seticonname", SetIconName, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "modemclose", ModemClose, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "dialproc", DialProc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand (interp, "killpid", KillPid, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  return TCL_OK;
}

