/*
 *	FAILDEFS.H  --  this C header file defines the constants used
 *			to indicate the exit status of the POP2 server.
 *
 *      (C) Copyright 1991 Regents of the University of California
 *
 *      Permission to use, copy, modify, and distribute this program
 *      for any purpose and without fee is hereby granted, provided
 *      that this copyright and permission notice appear on all copies
 *      and supporting documentation, the name of University of California
 *      not be used in advertising or publicity pertaining to distribution
 *      of the program without specific prior permission, and notice be
 *      given in supporting documentation that copying and distribution is
 *      by permission of the University of California.
 *      The University of California makes no representations about
 *      the suitability of this software for any purpose.  It is provided
 *      "as is" without express or implied warranty.
 *
 *	REVISIONS:
 *			 3-88	[ks]	original implementation
 *		1.000	 5-88	[ks]
 *
 */

#define FAIL_CANT_RECV		0x41		/* Fail on read from client */
#define FAIL_CANT_SEND		0x42		/* Fail on send to client */
#define FAIL_FILE_CANT_LOCK	0x43		/* Cant lock output file */
#define FAIL_FILE_CREATE	0x44		/* Cant open file for write */
#define FAIL_FILE_IO_ERROR	0x45		/* File read/write error */
#define FAIL_FILE_NOT_FOUND	0x46		/* Essential file not found */
#define FAIL_FILE_SETUP		0x47		/* Cant setup for file use */
#define FAIL_LOST_CLIENT	0x48		/* Timeout waiting for client */
#define FAIL_OUT_OF_MEMORY	0x49		/* Out of allocable memory */
#define FAIL_SERVER_LOST	0x4a		/* Server is totally confused */
#define FAIL_SIG_BUS		0x4b		/* UNIX Bus error signal */
#define FAIL_SIG_HANG		0x4c		/* UNIX Hangup signal */
#define FAIL_SIG_ILLEGAL	0x4d		/* UNIX Illegal instruction */
#define FAIL_SIG_IOT		0x4e		/* UNIX IOT interrupt signal */
#define FAIL_SIG_SEG		0x4f		/* UNIX Segmentation error */
#define FAIL_SIG_TERM		0x50		/* UNIX Termination signal */
#define FAIL_SIG_URGENT		0x51		/* UNIX Urgent socket signal */
