/*
 *  Project   : tin - a Usenet reader
 *  Module    : xref.c
 *  Author    : I.Lea & H.Brugge
 *  Created   : 01-07-93
 *  Updated   : 06-07-93
 *  Notes     :
 *  Copyright : (c) Copyright 1991-93 by Iain Lea & Herman ten Brugge
 *              You may  freely  copy or  redistribute  this software,
 *              so  long as there is no profit made from its use, sale
 *              trade or  reproduction.  You may not change this copy-
 *              right notice, and it must be included in any copy made
 */

#include	"tin.h"

/*
 *  read LIBDIR/overview.fmt file to check if Xref:full is enabled/disabled
 */
 
int 
overview_xref_support ()
{
	char buf[LEN];
	char *ptr;
	FILE *fp;
	int supported = FALSE;
		
	fp = open_overview_fmt_fp ();

	if (fp != (FILE *) 0) {
		while (fgets (buf, sizeof (buf), fp) != (char *) 0) {
			ptr = strrchr (buf, '\n');
			if (ptr != (char *) 0) {
				*ptr = '\0';
			}
			if (strcmp (buf, "Xref:full") == 0) {
				supported = TRUE;
				break;
			}
		}
		fclose (fp);
	}
	
	return supported;
}

/*
 *  mark all other Xref: crossposted articles as read when one article read
 *  Xref: sitename newsgroup:artnum newsgroup:artnum [newsgroup:artnum ...]
 */
 
void 
mark_all_xref_read (art, group_path)
	struct t_article *art;
	char *group_path;
{
	char *xref_ptr;
	char *group;
	char *ptr, c;
	int i;
	long artnum;

	if (art->xref == '\0') {
		return;
	}

	xref_ptr = art->xref;
/*
	if (debug == 2) {
		sprintf (msg, "Processing Xref %ld  [%s]...", art->artnum, xref_ptr);
		error_message (msg, "");
	}
*/
	/*
	 *  check sitename matches nodename of current machine
	 */

	/* skip check for now */
	while (*xref_ptr != ' ' && *xref_ptr) {
		xref_ptr++;
	}

	/*
	 *  tokenize each pair and update that newsgroup if it is in my_group[].
	 */
	for (;;) {
		while (*xref_ptr == ' ') {
			xref_ptr++;
		}
		group = xref_ptr;
		while (*xref_ptr != ':' && *xref_ptr) {
			xref_ptr++;
		}
		if (*xref_ptr != ':') {
			break;
		}
		ptr = xref_ptr++;
		artnum = atol (xref_ptr);
		while (*xref_ptr >= '0' && *xref_ptr <= '9') {
			xref_ptr++;
		}
		if (&ptr[1] == xref_ptr) {
			break;
		}
		c = *ptr;
		*ptr = 0;
		i = find_group_index (group);
/*
		if (debug == 2) {
			sprintf (msg, "grp=[%s]  active[%d]=[%s]  unread=[%d]  artnum=[%ld]", 
				group, i, active[i].name, active[i].unread, artnum);
			error_message (msg, "");
		}
*/
		if (i >= 0 && active[i].newsrc) {
			checknewsrc (i);
			if (artnum >= active[i].min && artnum <= active[i].max &&
			    NTEST(active[i].newsrc, artnum - active[i].min) &&
			    active[i].unread > 0) {
					NRESET(active[i].newsrc, artnum - active[i].min);
					active[i].unread--;
					active[i].newsrcupdate = TRUE;
			}
		}
		*ptr = c;
	}
}
