#include <errno.h> 
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h> 
#include <sys/wait.h>

#define VER "1.00"

int main (int argc, char **argv)
{
    register int
	pid;
    int
	result;
    
    if (argc < 3)
    {
	printf ("ICCE Change-Root Facility  V" VER "\n"
		"Copyright (c) K. Kubat / ICCE, 1994. All rights reserved.\n"
		"Another MegaHard production!\n"
		"\n"
		"chroot by Karel Kubat (karel@icce.rug.nl)\n"
		"\n"
		"Usage: chroot new-root-dir program [arguments to program]\n"
		"Will set the new root directory to `new-root-dir' and start"
			" `program'.\n"
		"The new root remains in effect as long as `program' is"
			" running.\n"
		"\n");
	exit (1);
    }

    if (chroot (argv [1]))
    {
	fprintf (stderr, "chroot: can't set new root dir to \"%s\"\n",
		 argv [1]);
	switch (errno)
	{
	    case EPERM:
		fprintf (stderr, "Permission denied.\n");
		break;
	    case EROFS:
		fprintf (stderr, "Read-only filesystem.\n");
		break;
	    case EFAULT:
		fprintf (stderr, "Path points outside address space.\n");
		break;
	    case ENAMETOOLONG:
		fprintf (stderr, "Path too long.\n");
		break;
	    case ENOENT:
		fprintf (stderr, "Path does not exist.\n");
		break;
	    case ENOMEM:
		fprintf (stderr, "Insufficient kernel memory.\n");
		break;
	    case ENOTDIR:
		fprintf (stderr, "Path is no directory.\n");
		break;
	    case EACCES:
		fprintf (stderr, "Search permission denied.\n");
		break;
	    case ELOOP:
		fprintf (stderr, "Path contains circular reference.\n");
		break;
	}
	exit (1);
    }

    argv++;
    argv++;

    if ( (pid = fork ()) == -1 )
    {
	fprintf (stderr, "chroot: can't fork\n");
	exit (1);
    }

    if (! pid)
    {
	execvp (argv [0], argv);
	fprintf (stderr, "chroot: can't exec \"%s\"\n", argv [0]);
    }
    else
    {
	wait (&result);
	printf ("chroot: \"%s\" exited, original root directory active.\n",
		argv [0]);
	if (WIFEXITED (result))
	    printf ("Program terminated normally with status %d.\n",
		    WEXITSTATUS (result));
	else if (WIFSIGNALED (result))
	    printf ("Program was signalled with signal %d.\n",
		    WTERMSIG (result));
    }

    return (0);
}
