#include <config.h>
/*****************************************************************/
/***                                                           ***/
/***    Play out a file on stdout in u-law encoding            ***/
/***                                                           ***/
/***                H.F. Silverman 1/4/91                      ***/
/***    Modified:   Rob Janssen (pe1chl@wab-tis.rabobank.nl)   ***/
/***                adapted for use with ZyXEL                 ***/
/***                                                           ***/
/*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>
#include <ctype.h>
#include <unistd.h>

#include "proto.h"
#include "getargs.h"
#include "hplay.h"
#include "l2u.h"

#define SAMP_RATE 9600
long samp_rate = SAMP_RATE;

/* Audio Parameters */

char *prog = "hplay";

#ifdef DEBUG
int min,max;
#endif

int
audio_init (int argc, char *argv[])
{
  prog = argv[0];
  return argc;
}

void
audio_term ()
{
  close(1);
#ifdef DEBUG
  fprintf(stderr,"data range: %d..%d\n",min,max);
#endif
}

void
audio_play (int n, short *data)
{
  if (n > 0)
    {
      unsigned char *converted = (unsigned char *) malloc (n);
      int i;

      if (converted == NULL)
	{
	  fprintf (stderr, "Could not allocate memory for conversion\n");
	  exit (3);
	}

      for (i = 0; i < n; i++) {
#ifdef DEBUG
	if (*data > max)
	    max = *data;

	if (*data < min)
	    min = *data;
#endif

	converted[i] = short2ulaw(2 * *data++);
      }

      if (write (1, converted, n) != n)
	perror ("write");

      free (converted);
    }
}
