/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "cbgetty.h"

/*
    We should have the tty-line as argv[1]
*/    

void main (int argc, char **argv)
{
    int
	state,
	uid;

    progversion(argv[0], CBGETTY_VERSION);

    parse_setupfile();			    /* parse the setupfile */

    tty_names(argv[1]);			    /* define the tty_line */

    if (getstate(&state, &uid))		    /* if state indicates callback */
    {					    /* mode: */
	state--;			    /* decrement state */
	writestate(state, uid);		    /* update state file */
	if (!state)			    /* if at zero, reset to waiting */
	    copyfile(filename[the_orgfile], filename[the_destfile]);
    }
	
    argv[0] = filename[the_modemfile];	    /* overlay ourselves with */

    log(log_on, "Execing %s from cbgetty", argv[0]);

    execv(argv[0], argv);		    /* original getty program */

    /* we should never get here */
    error("Can't exec %s.", argv[0]);
}
		      
