/* $Header: /home/klaus/mgetty/voice/RCS/pvfmain.c,v 1.9 1994/07/26 23:57:07 klaus Exp $ */
/* The dispatcher for the pvf utilities. It looks up the name in
 * argv[0] and calls the appropiate subroutine.
 */

#include <stdio.h>
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif
#include <string.h>
#include "mgetty.h"
#include "pvflib.h"

typedef int pvffunc _PROTO((int, char**));

extern pvffunc pvfamp, pvfcut, pvfecho, pvfsine,
               pvfreverse, pvfspeed, pvfmix, pvfadpcm,
               pvftoau, autopvf, pvftobasic, basictopvf,
               pvftolin, lintopvf, pvftovoc, voctopvf,
               pvffft;

typedef struct {
	char *name;
	pvffunc *func;
} tab_t;

static tab_t tab[]={
	{"pvfamp", pvfamp},
	{"pvfcut", pvfcut},
	{"pvfecho", pvfecho},
	{"pvfreverse", pvfreverse},
	{"pvfspeed", pvfspeed},
	{"pvfmix", pvfmix},
	{"pvfsine", pvfsine},
	{"pvffft", pvffft},
	    
	{"pvftoadpcm2", pvfadpcm},
	{"pvftoadpcm3", pvfadpcm},
	{"pvftoadpcm4", pvfadpcm},
	{"adpcmtopvf",  pvfadpcm},

	{"pvftoau", pvftoau},
	{"autopvf", autopvf},

	{"pvftobasic", pvftobasic},
	{"basictopvf", basictopvf},

	{"pvftolin", pvftolin},
	{"lintopvf", lintopvf},

	{"pvftovoc", pvftovoc},
	{"voctopvf", voctopvf},

	{0, 0}
};

char *command;   /* used in error messages, includes path name */

int
main _P2((argc, argv), int argc, char **argv) {
	int i=0;
	char *s, *cmd;

	command = cmd = argv[0];

	if( (s=strrchr(cmd, '/')) !=0 ) cmd=s+1;

	while( tab[i].name != 0 ) {
		if( strcmp(cmd, tab[i].name) ==0 ) {
			return tab[i].func(argc, argv);
		}
		i++;
	}
	ERRORRETURN("unknown command");
	return 1;
}
