#include "kiss.h"

int domount (Stringstack s)
{
    register int
	opt;
    register char
	*type = NULL;

    while ( (opt = getopt (s.nstr, s.str, "t:h")) != -1 )
	switch (opt)
	{
	    case 't':
		if (! (type = optarg))
		    error ("missing type after \"-t\"");
		break;
	    default:
	    case 'h':
		error ("Bad commandline.\n"
		       "Usage: %s [-t type] [-r] device directory\n"
		       "Where:\n"
		       "    -t type   : mount as type, e.g. ext2, minix\n"
		       "    device    : device to mount\n"
		       "    directory : mount point\n"
		       , progname);
	}

    if (s.nstr - optind != 2)
	error ("illegal number of arguments");

    if (! type)
	error ("need \"-t type\" specification");

    if (mount (s.str [optind], s.str [optind + 1], type, 1, 0))
	error ("problem mounting \"%s\" on \"%s\" (type \"%s\")",
	       s.str [optind + 1], s.str [optind], type);

    printf ("Note: /etc/mtab not updated.\n");
    return (0);
}
