/* 
Here are both external and built-in implementations of read, following v7
semantics on EOF (i.e., set the variable to '' and return 1), and a trip.read.

 b_read -- read a single line, terminated by \n or EOF, from the standard
 input, and assign the line without the terminator to av[1].
*/
#include "proto.h"
#include <stdio.h>
#include "addon.h"
typedef enum bool { FALSE, TRUE } bool;
extern void set(bool);

static int readchar (int fd) {
   unsigned char c;
   if (read (fd, &c, 1) == 1) return c;
   else return EOF;
}

void b_read (char **av) {
   char *name;
   int c;
   char *line;
   SIZE_T len;
   SIZE_T max_len;
   SIZE_T max_len_quantum;

/* check usage is "read name" */
   if (av[1] == NULL)
      rc_error ("missing variable name");
   if (av[2] != NULL)
      rc_error ("too many arguments to read");
   name = av[1];

/* read a single line from stdin */
   line = NULL;
   len = 0;
   max_len = 0;
   max_len_quantum = 256;
   do {
      c = readchar (0);
      if (len == max_len) 
	 line = (char*) erealloc (line, max_len += max_len_quantum);
      if (c == '\n' || c == EOF)
	 line[len] = 0;
      else
	 line[len] = c;
      len++;
   } while (c != '\n' && c != EOF);

/* assign whatever we read to the variable */
   assign (word (name, NULL), word (line, NULL), FALSE);
   efree (line);

/* return TRUE if we terminated with a \n, otherwise FALSE */
   set (c == '\n');

   return;
}
