#include "addon.h"
typedef enum bool { FALSE, TRUE } bool;
extern void set(bool);
#include <stdio.h>   /* need for printf() */
#include <stdlib.h>  /* need for atio() */
/*
ANSI C program to output a sequence of integers:  seq <n1> <n2> [step]
outputs the integers n1 .. n2 with an optional positive *or* negative step size.
Note that the use of sign in the for loop condition ensures proper termination.
RETURN VALUES: 0 -OK, 1 -invalid step, 2 step/order mismatch.
Modified to be an rc builtin.            Chuck Blake, 03-14-1994 */

void b_seq(char* argv[]) {
    int i, argc=0, arg1, arg2, step, sign;

/* argument processing */
    while (argv[argc] != 0) ++argc;

    if (argc<3 || argc>4) {
        printf("seq n1 n2 [step] outputs the sequence (n1..n2 by step)\n");
        set(FALSE);
        return;
    }
    arg1 = atoi(argv[1]);
    arg2 = atoi(argv[2]);
    step = (argc==4) ? atoi(argv[3]) : 1;
    if (step==0) {
        set(FALSE);
        return;
    }
    if (step>0 && arg1>arg2) {
        set(FALSE);
        return;
    }

/* main logic */
    sign = (step>0) ? 1 : -1;
    for(i=arg1; sign*i <= sign*arg2; i+=step)
        printf("%i ",i);
    set(TRUE);
    return;
}
