/*
    yamm, Yet Another Micro Monitor
    define.h
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined(_DEFINE_YH)
#define _DEFINE_YH 1

/*
 * Add this for strict ANSI compilation with GCC
 */
#if defined(__linux__)
# if !defined(linux)
# define linux
# endif /* !linux */
#endif /* __linux__ */

#include "kversion.h"
#if !defined(linux)
#ifndef MAX_PROC
#define MAX_PROC 512
#endif /* !MAX_PROC */
#else
#include <linux/tasks.h>
#define MAX_PROC NR_TASKS
#endif /* !linux */

/*
 * MAX_LOGIN is defined to 8, this is needed by the code in main.c
 * where if the login name is more than 8 chars, it is truncated to 8
 * to best fit it in the screen
 */
#define MAX_LOGIN 8

#include <stdio.h>
#include <stdlib.h>
#if !defined(linux)
# include <sys/pstat.h>
#endif /* !linux */
#include <unistd.h>
#include <signal.h>

#include "fakestat.h"
#include "version.h"

#if defined(NCURSES)
#define MAIN_PAIR 1
#endif /* NCURSES */

#if defined(linux)

#if (KERNEL_VERSION < 1001076)
/*
 * These are needed by lib/wchan.c
 */
#define _ETC_ZSYSTEM_MAP	"/etc/zSystem.map"
#define _USRSRC_ZSYSTEM_MAP	"/usr/src/linux/zSystem.map"
#else
#define _ETC_ZSYSTEM_MAP	"/etc/System.map"
#define _USRSRC_ZSYSTEM_MAP	"/usr/src/linux/System.map"
#endif /* KERNEL_VERSION < 1001076 */

/*
 * CPU states. See conf.c for use of these defines
 */
#define CPUSTATES       4  /* Number of CPU states */

#define CP_USER         0	/* user mode of USER process */
#define CP_NICE         1	/* user mode of USER process at nice priority */ 
#define CP_SYS          2	/* kernel mode of USER process */
#define CP_IDLE         3	/* IDLE mode */

#endif /* linux */

#endif /* _DEFINE_YH */
