/*
    yamm, Yet Another Micro Monitor
    drv_yamm.h
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined(_DRV_YAMM_YH)
#define _DRV_YAMM_YH 1

#include <sys/ioctl.h>

#define IOCGETCMD(cmd)  ((cmd) & IOCPARM_MASK)
#define IOCSIZE(cmd)   (((cmd) & ~IOCPARM_MASK) >> IOCSIZE_SHIFT)

/*
 * No upper limit in parameter size: 16 bits.
 */
#define _IOC(c,d,t) ((t<<IOCSIZE_SHIFT) | \
                   ((c)<<8) | (d))

/*
 * drv_yamm ioctl(s): programmer's reference.
 *
 * #include <fakestat.h>
 *
 * ioctl(int fd, int reqest, struct pst_status * arg)
 *
 * Requests:
 *
 * YIOCGVER		get drv_yamm version.
 *		Param:	long * arg.
 *				arg points to the version of drv_yamm in the form:
 *
 *				byte		|	byte	|	byte	|	byte
 *
 *				yamm ver	| yamm majr	| yamm minr	| patch char
 *
 * YIOCGPROC	get the complete process table.
 *		Param:  struct pst_status * arg.
 *				arg points to an area of memory where it will be stored
 *				the entire process table. (array or malloc'ed)
 *
 * YIOCGFTSK	get the first task (pid==1), init.
 *		Param:	struct pst_status * arg.
 *				arg points to a single pst_status structure.
 *
 * YIOCGNTSK	get next task in the process table.
 *		Param:	struct pst_status * arg.
 *				arg points to a single pst_status structure.
 *
 * YIOCGOPROC(pid)
 *				get one single process, specified in 'pid'
 *				parameter.
 *		Param:	struct pst_status * arg.
 *				arg points to a single pst_status structure.
 *
 * Return:		0 on success.
 */
#define YIOCGVER		_IO  ('Y', 0)
#define YIOCGPROC		_IO  ('Y', 1)
#define YIOCGFTSK		_IO  ('Y', 2)
#define YIOCGNTSK		_IO  ('Y', 3)
#define YIOCGOPROC_cmd	_IO  ('Y', 4)
#define YIOCGOPROC(pid)	_IOC ('Y', 4, pid)

#if defined(__DRV_YAMM__)
extern struct task_struct *RewindTasks(void);
extern int yamm_ioctl(struct inode * node,struct file * file,
                        unsigned int cmd, unsigned long arg);
extern int init_module(void);
extern void cleanup_module(void);
#endif /* __DRV_YAMM__ */

#endif /* _DRV_YAMM_YH */
