/*
    yamm, Yet Another Micro Monitor
    fakestat.h
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This file is made without any knowledge of the original HP-UX pstat.h
 * header file. I've just guessed the members of structures by looking in
 * the source files of yamm and trying to compile it.
 *
 * I think this may be a good start for a try to port yamm on systems other
 * than HP-UX
 * - Riccardo -
 */
 
#if !defined(_FAKESTAT_YH)
#define _FAKESTAT_YH

#if !defined(linux)
#include <sys/param.h>
#endif /* !linux */
/*
 * See lib/signals.c for signal structure. Change it as needed for porting.
 */

struct Signames {
char *name;
int  signo;
};

#if defined(linux)
/*
 * func_tab, is the structure that hold an entry of the kernel
 * function table. This is needed by the wchan code (see wchan.c)
 */
struct func_tab {
        unsigned long start;
        char type;
        char name [ 32 ];
};
#endif /* linux */

#if !defined(__hpux) && (defined(linux)/* || other OS */)
/*
 * (you must use this data structures to port)
 */

/*
 * In these structures i have put not only the HP specific fields, but i've
 * added the linux specific ones. This is the simplest way to handle linux
 * specific informations
 */

struct pst_dynamic {
long  psd_vm;		/* Total virtual memory */
long  psd_avm;		/* Active virtual memory */
long  psd_rm;		/* Total real memory */
long  psd_arm;		/* Active real memory */
long  psd_free;		/* Free memory */
#if defined(linux)
long  psd_shared;	/* shared ram */
long  psd_buffers;	/* buffers ram */
#endif /* linux */
float psd_avg_1_min;	/* Load averages */
float psd_avg_5_min;
float psd_avg_15_min;
long  psd_rq;		/* Run queue length */
long  psd_dw;		/* Jobs in disk wait */
long  psd_pw;		/* Jobs in page wait */
long  psd_sl;		/* Jobs sleeping in core */
long  psd_sw;		/* Swapped out runnable jobs */
long *psd_cpu_time;	/* if def CPUSTATES (look at conf.c and above in this file) */
};

struct pst_static {
long  page_size;	/* Page size */
long  physical_memory;	/* Physical_memory */
long  max_proc;		/* Max process */
long  boot_time;	/* Boot time */
};

struct pst_vminfo {	/* s* -> absolute values, r* -> ratio values */
long  psv_ssyscall;	/* Calls to syscall() */
long  psv_rsyscall;
long  psv_spgpgin;	/* Pages paged in */
long  psv_rpgpgin;
long  psv_spgpgout;	/* Pages paged out */
long  psv_rpgpgout;
long  psv_sswtch;	/* Context switches */
long  psv_rswtch;
long  psv_sintr;	/* Device interrupts */
#if defined(linux)
unsigned psv_interrupts[16];	/* interrupts ... guess what ? :) */
#endif
long  psv_rintr;
long  psv_sswpin;	/* Swapins */
long  psv_sswpout;	/* Swapouts */
long  psv_cntfork;	/* Number of forks */
long  psv_spgin;	/* Pageins */
long  psv_spgout;	/* Pageouts */
long  psv_spswpin;	/* Pages swapped in */
long  psv_spswpout;	/* Pages swapped out */
long  psv_spgrec;	/* Total page reclaims */
long  psv_strap;	/* Calls to trap */
long  psv_cfree;	/* Free memory pages */
};

struct pst_status { /* per-process structure */
#if defined(linux)
unsigned short pst_uid;			/* uid */
unsigned short pst_suid;			/* suid */
#if defined(MODULE)
unsigned short pst_gid;			/* gid */
unsigned short pst_fsuid;		/* fsuid */
#endif /* MODULE */
int   pst_pid;			/* pid */
int   pst_ppid;			/* parent pid */
#endif /* linux */
long  pst_nice;			/* nice */
long  pst_pri;			/* priority */
#if defined(linux)
int   pst_pgrp;			/* process group */
#endif /* linux */
long  pst_time;			/* Resident time for scheduling */
long  pst_utime;		/* user time */
long  pst_stime;		/* system time */
long  pst_start;		/* start of execution */
long  pst_cpticks;		/* Ticks of cpu time */
long  pst_cptickstotal;		/* Total ticks for life of process */
double pst_pctcpu;		/* %cpu for this process during p_time */
#if !defined(linux)
long  pst_tsize;		/* text */
long  pst_dsize;		/* data */
long  pst_ssize;		/* stack */
#else
long  pst_vsize;		/* the memory really used */
/*
 * see /proc/<pid>/statm
 */
int   pst_size;
int   pst_resident;
int   pst_share;
int   pst_trs;
int   pst_lrs;
int   pst_drs;
int   pst_dt;
#endif /* !linux */
long  pst_rssize;		/* resident set size */
char  pst_stat;			/* status of the process (Sleeping, Running, ...) */
#if defined(linux)
char  pst_cmd[16];		/* command name */
#else
char  pst_cmd[MAXPATHLEN];	/* command name */
#endif /* linux */
char  pst_tty[64];		/* tty attached to the process */
#if defined(linux)
#if defined(MODULE)
struct tty_struct *pst_k_tty;	/* tty attached to the process */
int   pst_swappable:1;		/* if swappable */
#endif /* MODULE */
long  pst_min_flt;		/* minor page faults */
long  pst_cmin_flt;		/* children minor page faults */
long  pst_maj_flt;		/* major page faults */
long  pst_cmaj_flt;		/* children major page faults */
long  pst_cutime;		/* children user time */
long  pst_cstime;		/* children system time */
long  pst_flags;		/* process flags PF_* in <linux/sched.h> */
int   pst_session;		/* session id */
long  pst_it_real_value;	/* itimer real value */
long  pst_signal;		/* pending signals mask */
long  pst_blocked;		/* blocked signals mask */
long  pst_sigignore;		/* ignored signals mask */
long  pst_sigcatch;		/* catched signals mask */
long  pst_wchan;		/* WCHAN (seems to be a return address) */
#endif /* linux */
};

#if defined(linux)
struct lin_status { /* per-process Linux filesystem /proc data structure */
int   lin_pid;			/* process id */
#if defined(linux)
char  lin_cmd[16];		/* command name */
#else
char  lin_cmd[MAXPATHLEN];	/* command name */
#endif /* linux */
char  lin_stat;			/* process status */
int   lin_ppid;			/* parent process id */
int   lin_pgrp;			/* process group */
int   lin_session;		/* session id */
int   lin_tty;			/* tty line MAJOR << ? + MINOR */
int   lin_tty_pgrp;		/* tty process group */
long  lin_flags;		/* process flags PF_* in <linux/sched.h> */
long  lin_min_flt;		/* minor page faults */
long  lin_cmin_flt;		/* children minor page faults */
long  lin_maj_flt;		/* major page faults */
long  lin_cmaj_flt;		/* children major page faults */
long  lin_utime;		/* user time */
long  lin_stime;		/* system time */
long  lin_cutime;		/* children user time */
long  lin_cstime;		/* children system time */
long  lin_pri;			/* priority */
long  lin_nice;			/* nice */
long  lin_tmout;		/* Timeout time for scheduling */
long  lin_it_real_value;	/* itimer real value */
long  lin_start;		/* start of execution */
long  lin_vsize;		/* total size t + d + s NOT pages */
long  lin_rss;			/* residend set size pages */
long  lin_rlim_cur;		/* current rlimit ro rss */
long  lin_start_code;		/* start of code */
long  lin_end_code;		/* end of code */
long  lin_start_stack;		/* start of stack */
long  lin_esp;			/* head of stack (stack pointer) */
long  lin_eip;			/* instruction pointer */
long  lin_signal;		/* pending signals mask */
long  lin_blocked;		/* blocked signals mask */
long  lin_sigignore;		/* ignored signals mask */
long  lin_sigcatch;		/* catched signals mask */
long  lin_wchan;		/* WCHAN (seems to be a return address) */
};
#endif /* linux */
#endif /* !__hpux && (linux || other OS) */

#endif /* _FAKESTAT_YH */
