/*
    yamm, Yet Another Micro Monitor
    src/X/main.cc
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <uit/BaseWindow.h>
#include <uit/ComponentDisplay.h>
#include <uit/TextItem.h>
#include <uit/Notifier.h>
#include <uit/Gauge.h>
#include <uit/AlphanumericInput.h>
#include <uit/NumericInput.h>
#include <uit/ListChoice.h>
#include <uit/UIChoice.h>
#include <uit/UIObject.h>

#include <xview/notify.h>

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <math.h>

/* yamm includes */
#include <extern.h>
#include <fakestat.h>
#include <define.h>
#include <version.h>

#define BASEHEIGHT 300
#define BASEWIDTH  500
#define BARHEIGHT   30
#define BARWIDTH   500

Notify_value update (void);

itimerval timer;

BaseWindow base("XYAMM " YAMM_VERSION);

ListChoice ProcList ("Processes");

main(int argc, char **argv) {

	init_yamm();

	base.initUI(argc, argv);
	base.setHeight (BASEHEIGHT);
	base.setWidth (BASEWIDTH);

	ComponentDisplay MenuBar;

	MenuBar.setX (0);
	MenuBar.setY (0);
	MenuBar.setHeight (BARHEIGHT);
	MenuBar.setWidth (BARWIDTH);
	MenuBar.setExtendToEdge(WIDTH);
	MenuBar.setExtendToEdge(HEIGHT);
	base.addDisplay (MenuBar);

	ComponentDisplay Disp;

	Disp.setX (0);
	Disp.setY (BARHEIGHT);
	Disp.setHeight (BASEHEIGHT - BARHEIGHT);
	Disp.setWidth (BASEWIDTH);
	Disp.setExtendToEdge(WIDTH);
	Disp.setExtendToEdge(HEIGHT);
	ProcList.setX (0);
	ProcList.setY(BARHEIGHT);
	ProcList.setHeight (BASEHEIGHT - BARHEIGHT);
	ProcList.setWidth (BASEWIDTH);
	Disp.addComponent (ProcList);
	base.addDisplay (Disp);


	update();

// Create objects so that we have a frame to attach the timer to
	Notifier n;
	n.createXViewObjects ();

	timer.it_value.tv_sec = 1;
	timer.it_value.tv_usec = 0;
	timer.it_interval.tv_sec = 1;
	timer.it_interval.tv_usec = 0;

// Start the timer
	unsigned long frame = (unsigned long)base.getXViewObject();
	if (frame == 0) {
	fprintf(stderr, "Error: XView frame not set for timer init\n");
	exit(1);
	}
	notify_set_itimer_func(frame, update, ITIMER_REAL, &timer, NULL);
	n.start();
}

Notify_value update (void) {
	static char buffer[1024];
	int i, ret;
	static int old_ret = 0;

	ret = PS_proc ( &pbuf, MAX_PROC, 0 );

	for (i=0; i<ret; i++) {
		sprintf(buffer, "%c%c %-*s %c%5ld %5ld %2ld %3ld %s ",
			/*get_status ( i ),*/'S',
			pbuf [ i ].pst_rssize ? ' ' : 'W',
			MAX_LOGIN,
			/*get_user ( i ),*/"prova",
			pbuf [ i ].pst_uid != pbuf [ i ].pst_suid ? '*':' ',
			pbuf [ i ].pst_suid,
			pbuf [ i ].pst_pid,
			pbuf [ i ].pst_nice,
			pbuf [ i ].pst_pri,
#if !defined(linux)
			get_dimension (  pbuf [ i ].pst_dsize +
				pbuf [ i ].pst_tsize  + pbuf [ i ].pst_ssize ) );
#else
			/*get_dimension (  pbuf [ i ].pst_vsize )*/"dimension" );
#endif /* linux */
		if (old_ret == 0)
			ProcList.addChoice(buffer);
		else {
			if (i < old_ret)
				ProcList.replaceChoice(i, buffer);
			else
				ProcList.addChoice(buffer);
		}
	}

	for (i=ret;i<old_ret;i++)
		ProcList.deleteChoice(i);

	old_ret = ret;
	return (notify_value)NOTIFY_DONE;
}	
