/*
    yamm, Yet Another Micro Monitor
    comp_dim.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "yamm.h"

/*
 * "size" is data + text + stack
 */
int compare_size( struct pst_status *a, struct pst_status *b )
{
#if !defined(linux)
	register long size_a = a->pst_dsize + a->pst_tsize + a->pst_ssize;
	register long size_b = b->pst_dsize + b->pst_tsize + b->pst_ssize;
#else
	register long size_a = a->pst_vsize;
	register long size_b = b->pst_vsize;
#endif /* !linux */

	if ( invert )
		return ( size_a < size_b ? -1 : size_a == size_b ? 0 : 1 );
	else
		return ( size_a < size_b ? 1 : size_a == size_b ? 0 : -1 );
		
}

/*
 * "ressize" is resident set size
 */
int compare_ressize( struct pst_status *a, struct pst_status *b )
{
	register long size_a = a->pst_rssize;
	register long size_b = b->pst_rssize;

	if ( invert )
		return ( size_a < size_b ? -1 : size_a == size_b ? 0 : 1 );
	else
		return ( size_a < size_b ? 1 : size_a == size_b ? 0 : -1 );
		
}
