/*
    yamm, Yet Another Micro Monitor
    get_cmdline.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/param.h>

#include "yamm.h"

/*
 * get_cmdline, get the complete command line from:
 * (linux) /proc/<pid>/cmdline
 * (hpux) the pst_status structure
 */
char *get_cmdline( struct pst_status pp )
{
#if defined(linux)
	static char cmdline[MAXPATHLEN];
	char buffer[25];
	register int characters;
	int fd;

	sprintf(buffer, "/proc/%u/cmdline", pp.pst_pid);

	if ((fd = open(buffer, O_RDONLY)) == -1)
		return pp.pst_cmd;

	if ((characters = read(fd, cmdline, MAXPATHLEN)) == -1)
		return pp.pst_cmd;

	close (fd);

	if ((characters == 0) || (cmdline[0] == '\0'))
		return pp.pst_cmd;

	cmdline[characters] = '\0';
	while (--characters)
		if (cmdline[characters] == '\0')
			cmdline[characters] = ' ';
	
	return cmdline;
#else
	return pp.pst_cmd;
#endif /* linux */
}
