/*
    yamm, Yet Another Micro Monitor
    get_status.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "yamm.h"

#define NUM_ELEM 6

#if !defined(linux)

struct _status {
	long def;
	char car;
	int num;
}; 

static struct _status ret_status [ NUM_ELEM ] = {
	{ PS_SLEEP, 'S', 0 },
	{ PS_RUN,   'R', 0 },
	{ PS_STOP,  'T', 0 },
	{ PS_ZOMBIE,'Z', 0 },
	{ PS_IDLE,  'I', 0 },
	{ PS_OTHER, 'O', 0 }
};

#else

struct _status {
	char car;
	int num;
};

static struct _status ret_status [ NUM_ELEM ] = {
	{ 'R', 0 /* RUN */    },
	{ 'S', 0 /* SLEEP */  },
	{ 'D', 0 /* SWAPPING | UNINTERRUPTIBLE */ },
	{ 'Z', 0 /* ZOMBIE */ },
	{ 'T', 0 /* STOP */   },
	{ '.', 0 /* OTHER */  }
};
#endif /* !linux */

char  get_status ( int index )
{
#if defined(linux)
/*
 * linux process status is alredy a char
 */
	return pbuf [ index ].pst_stat;
#else
	long status = pbuf [ index ].pst_stat;
	register int count;

	for ( count = 0 ; count < NUM_ELEM ; ++count )
		if ( status == ret_status[count].def )
			return ( ret_status[count].car );
	
	return ( '?' );
#endif /* linux */
}

void count_status( int nproc )
{
	register int process, state;

	for ( state = 0; state < NUM_ELEM; ++state )
		ret_status[state].num = 0L;
		
	for ( process = 0; process < nproc; ++process )
		for ( state = 0; state < NUM_ELEM; ++state )
#if !defined(linux)
			if ( pbuf[process].pst_stat == ret_status[state].def )
#else
			if ( pbuf[process].pst_stat == ret_status[state].car )
#endif /* !linux */
					ret_status[state].num++;
}

int status_sleep(void)
{
#if !defined(linux)
	return ( ret_status [ 0 ].num );
#else
	return ( ret_status [ 1 ].num );
#endif /* !linux */
}

int status_run(void)
{
#if !defined(linux)
	return ( ret_status [ 1 ].num );
#else
	return ( ret_status [ 0 ].num );
#endif /* !linux */
}

int status_stop(void)
{
#if !defined(linux)
	return ( ret_status [ 2 ].num );
#else
	return ( ret_status [ 4 ].num );
#endif /* !linux */
}

int status_zombie(void)
{
	return ( ret_status [ 3 ].num );
}

int status_other(void)
{
#if !defined(linux)
	return ( ret_status [ 4 ].num + ret_status [ 5 ].num );
#else
	return ( ret_status [ 2 ].num + ret_status [ 5 ].num );
#endif /* !linux */
}

char get_swstatus ( int index ) {
	if ( (pbuf [ index ].pst_rssize == 0) && (get_status(index) != 'Z'))
		return 'W';
	return ' ';
}

char get_nistatus ( int index ) {
	if (pbuf[index].pst_nice < 0)
		return '<';
	if (pbuf[index].pst_nice > 0)
		return 'N';
	return ' ';
}
