/*
    yamm, Yet Another Micro Monitor
    reg.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <regex.h>

#include "yamm.h"

static regex_t re;
static int active = 0;

int reg_match ( char *cmd )
{
	if ( active  )
		return ( !regexec ( &re, cmd, ( size_t )0, NULL,0 ));
	else
		return ( 0 );
}

void reg_set ( char *search )
{
	if ( search ) {
		
		if ( active ) {
			regfree( &re );
			active = 0;
		}

		if ( regcomp(&re, search, REG_EXTENDED|REG_ICASE|REG_NOSUB) == 0 ) 
			active = 1;
		return;
	}

	if ( active ) {
		regfree( &re );
		active = 0;
	}
}
