/*
    yamm, Yet Another Micro Monitor
    start_time.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <time.h>

#include "yamm.h"

#define MAX_BUF 10

static char *mo[] = {
	"Jan",
	"Feb",
	"Mar",
	"Apr",
	"May",
	"Jun",
	"Jul",
	"Aug",
	"Sep",
	"Oct",
	"Nov",
	"Dec"
};

int compare_start_time( struct pst_status *a, struct pst_status *b )
{
	if ( invert )
		return ( a->pst_start < b->pst_start ? -1 : a->pst_start == b->pst_start ? 0 : 1 );
	else
		return ( a->pst_start < b->pst_start ? 1 : a->pst_start == b->pst_start ? 0 : -1 );
		
}

char  *visual_start_time ( int index )
{
	static struct tm actual; 
	static int yet = 0;
	static char buf[ MAX_BUF ];
	struct tm *p_start_time = NULL;

	if ( !yet ) {
		time_t actual_time = time ( ( time_t *)0 );
		actual = *localtime ( &actual_time );
		yet = 1;
	}

	p_start_time = localtime ( &pbuf[ index ].pst_start );

	if ( p_start_time->tm_mday != actual.tm_mday )
			sprintf ( buf ,"-%2d %s-",
				p_start_time->tm_mday,
				mo [ p_start_time->tm_mon ] );
		else
			sprintf ( buf, "%2d:%.2d:%.2d", 
				p_start_time->tm_hour,
				p_start_time->tm_min,
				p_start_time->tm_sec );

	buf [ MAX_BUF - 1 ] = '\0';
	return ( buf );
}
