/*
    yamm, Yet Another Micro Monitor
    wutmp.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/types.h>
#include <utmp.h>
#include <time.h>
#if !defined(linux) || (KERNEL_VERSION < 1001076)
#include <string.h>
#else
#include <linux/string.h>
#endif
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#if defined(NCURSES)
# include "ncurses.h"
#else
# include <curses.h>
#endif /* NCURSES */

#include "yamm.h"

/*
 * This is a list of hosts that can connect to your machine.
 * If the host don't match, a '*' is printed near the address.
 * If you WANT disable this put NULL in first line. ( look at
 * line 27 ).
 *
 * Ex: I have:
 * static char *allow_list[] = {
 * "149.132",
 * "0.0.0.0",
 * NULL
 * };
 */

static char *allow_list[] = {
	"127.0.0.1",
	"0.0.0.0",
	NULL
};

static char allowed ( char *addr )
{
	register int count = 0;
	register char *host = NULL;

	if ( !allow_list [ 0 ] ) 
		return ( ' ' );

	for ( host = allow_list [ count ]; host; host = allow_list [ ++count ] )
		if ( !strncmp ( host, addr, strlen ( host )))
			return ( ' ' );
	
	return ( '*' );
}

void examine_utmp (void)
{
	register int count;
	struct utmp *us;
	struct tm *mtime;
	static char buffer [ 18 ];
	struct in_addr iaddr;

	setutent();

#if !defined(NO_CURSES)
#define PF (void)printw
#else
#define PF (void)printf
#endif /* !NO_CURSES */


	PF("\nUSER       TTY           HOST                 FROM                TIME    D/M\n");

	for ( count = displayed = 0, us = getutent(); us ; us = getutent() ) {

	if ( us->ut_type != USER_PROCESS )
		continue;

	strncpy ( buffer, us->ut_user, 8 );
	buffer [ 8 ] = '\0';

	if ( look_uid != -1L && look_uid != get_user_id( buffer ) ) 
		continue;

#if !defined(NO_CURSES)
	if ( count++ < pages*Num_display_proc )
		continue;
#endif /* !NO_CURSES */


	if ( Num_display_proc >= 0 && displayed >= Num_display_proc )
		break;

	displayed++;

	PF( "%-8s", buffer );

	strncpy ( buffer, us->ut_line, 12 );
	buffer [ 12 ] = '\0';
	PF( "   %-12s", buffer);

	strncpy ( buffer, us->ut_host, 16 );
	buffer [ 16 ] = '\0';
	iaddr.s_addr = us->ut_addr;
	PF ("  %-16s   %c %-16s", buffer,
		allowed ( inet_ntoa ( iaddr )),
				  inet_ntoa ( iaddr ));

	if ( ( mtime = localtime ( &us->ut_time ) ) != NULL ) 
		PF ("    %2d:%.2d  %2d:%.2d\n", 
			mtime->tm_hour,
			mtime->tm_min,
			mtime->tm_mday,
			mtime->tm_mon + 1 );
	else
		PF ("\n");
	}

	endutent();
}
