/***
 *** grabmode
 *** Copyright (c) 1995 by Koen Gadeyne (kmg@barco.be)
 ***
 *** This program outputs the current text or graphics mode, in an SVGATextMode (or XF86Config-like) compatible line
 *** Should work on ANY VGA card, since it only uses standard VGA registers
 ***
 ***/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef DOS
#include <unistd.h>
#include <asm/io.h>
#endif

#include "misc.h"
#include "messages.h"
#include "modedata.h"

#ifdef DOS
#define get_VGA_io_perm(x)
#undef Renounce_SUID
#define Renounce_SUID
extern int optind;
#endif

char *CommandName;
int debug_messages=FALSE;

void usage()
{
     PMESSAGE(("version %s. (c) 1995 Koen Gadeyne.\n Usage: %s [options] \n\n\
     Options: -n  Don't program VGA hardware\n\
              -d  print debugging information\n\
              -X  Output compatible with XF86Config mode line\n\
              -T  Output compatible with TextConfig mode line\n\
              -b  Also print blanking information\n\
              -c  Don't probe for pixel clock (just print timing information)\n\
              -h  print usage information\n",
     VERSION, CommandName));
}

/***********************************************************************************************************/
 
int main (int argc, char* argv[])
{
  int program_hardware=TRUE;
  int Xmode=MODE_UNDEFINED;
  int showblank=FALSE;
  int probe_clock=TRUE;
  char c;
  modestruct m;
  
  CommandName = argv[0];
 
 /*
  * command-line argument parsing
  */

  while ((c = getopt (argc, argv, "ndhXTbc")) != EOF)
    switch (c)
    {
      case 'n': program_hardware=FALSE;
                break;
      case 'd': debug_messages=TRUE;
                break;
      case 'X': Xmode = MODE_GRAPHICS;
                break;
      case 'T': Xmode = MODE_TEXT;
                break;
      case 'b': showblank = TRUE;
                break;
      case 'c': probe_clock = FALSE;
                break;
      case 'h': usage();
                exit(0);
                break;
      case '?': usage();
#ifndef DOS
                PERROR(("Bad option '-%c'\n",(char)optopt));
#endif                
                exit(-1);
                break;
      default: PERROR(("getopt returned unknown token '%c'.",c));
    }

/*
 * start doing something useful
 */
 
 if (program_hardware)
  {

     PWARNING(("Please be patient. This may take a while (up to 1 minute)"));

     getmode(&m, probe_clock);

    /*
     * From parameters, look for special settings that affect the output
     */
     
     /* auto selection between graphics/text mode if not defined on command line */
     if (Xmode==MODE_UNDEFINED) Xmode = m.txt_gr_mode;
     
    /*
     * Print the mode line
     */
     
    if (Xmode==MODE_TEXT)
      printf("\"%dx%d\"   ", m.activepix/8, m.activelines/m.font_height);
    else 
      printf("\"%dx%d\"   ", m.activepix, m.activelines);

    if (probe_clock)
      printf("%1.3f", m.pclock);
    else
      printf("***");
            
    printf("   %d %d %d %d   %d %d %d %d   %cHsync %cVsync",
           m.activepix, m.start_hsync, m.stop_hsync, m.totalh, m.activelines, m.start_vsync, m.stop_vsync, m.totalv,
           (m.h_polarity > 0) ? '+' : '-', (m.h_polarity > 0) ? '+' : '-');
           
    if (m.mode_flags & DOUBLESCAN) printf("  DoubleScan");
    if (m.mode_flags & MULTISCAN) printf("  MultiScan");

    if (Xmode==MODE_TEXT) printf("  font %dx%d", m.font_width, m.font_height);
    
    if (probe_clock)    
      printf("   # %1.3fkHz/%1.2fHz\n", m.hor_freq, m.vert_refresh);
    else
      printf("\n");
      
    if (showblank)
      printf("#   Blanking: H=%d-%d ; V=%d-%d\n", m.starthbl, m.endhbl, m.startvbl, m.endvbl);
      
  }
  return(0);
}
