/***
 *** SVGA clock programming functions for SVGATextMode
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _SETCLOCK_H
#define _SETCLOCK_H

typedef unsigned char byte;
typedef int Bool;  /* for XFREE clock chip code */


/*
 * Cirrus Logic specific clock stuff
 */

#define CIRRUS_MIN_CLOCK 5.0
#define CIRRUS_MAX_CLOCK 85.0
#define CIRRUS_CLOCK_REF (14.318*2)   /* or 28.322 ??? */
#define CIRRUS_REF_KHZ (int)(CIRRUS_CLOCK_REF*1000)


/*
 * Supported ClockChips
 */
 
#define NUM_CLKCHIPS       14

#define CLKCHIP_NONE        -1
#define CLKCHIP_ICD2061A     0
#define CLKCHIP_ICS9161A     1
#define CLKCHIP_DCS2834      2
#define CLKCHIP_SC11412      3
#define CLKCHIP_S3GENDAC     4
#define CLKCHIP_S3_SDAC      5
#define CLKCHIP_TI3025       6
#define CLKCHIP_ICS2595      7
#define CLKCHIP_ICS5300      8
#define CLKCHIP_ICS5342      9
#define CLKCHIP_CH8391       10
#define CLKCHIP_S3TRIO       11
#define CLKCHIP_CIRRUS       12
#define CLKCHIP_ICS5341      13

#define CLKCHIP_STRINGS      { "icd2061a" , "ics9161a" , "dcs2834" , "sc11412" , "s3gendac" , "s3_sdac",\
                               "ti3025" , "ics2595" , "ics5300" , "ics5342" , "ch8391" , "S3Trio" ,\
                               "Cirrus" , "ics5341" }

/* allowed clockchips per chipset (in bit mask format) */
#define CLOCKCHIPS_ALLOWED   { 0,   /* VGA */\
                              1<<CLKCHIP_ICD2061A | 1<<CLKCHIP_ICS9161A | 1<<CLKCHIP_DCS2834 | 1<<CLKCHIP_SC11412\
                               | 1<<CLKCHIP_S3GENDAC | 1<<CLKCHIP_S3_SDAC | 1<<CLKCHIP_TI3025 | 1<<CLKCHIP_ICS2595\
                               | 1<<CLKCHIP_ICS5300 | 1<<CLKCHIP_ICS5342 | 1<<CLKCHIP_CH8391 | 1<<CLKCHIP_S3TRIO,   /* S3 */\
                              1<<CLKCHIP_CIRRUS,   /* Cirrus */\
                              1<<CLKCHIP_ICS5341,  /* ET4000 */\
                              0,   /* TVGA8900 */\
                              0,   /* TVGA9000 */\
                              0,   /* PAVGA1 */\
                              0,   /* WDC90C0X */\
                              0,   /* WDC90C1X */\
                              0,   /* WDC90C2X */\
                              0,   /* WDC90C3X */\
                              0,   /* ATI */\
                              0,   /* ATIMACH32 */\
                              0    /* VIDEO7 */\
                            }

/* max TEXTMODE clocks for each chipset */
#define CLOCK_LIMITS        { 45.00,   /* VGA */\
                              70.00,   /* S3 */\
                              55.00,   /* Cirrus */\
                              95.00,   /* ET4000 */\
                              50.00,   /* TVGA8900 */\
                              45.00,   /* TVGA9000 */\
                              45.00,   /* PAVGA1 */\
                              50.00,   /* WDC90C0X */\
                              50.00,   /* WDC90C1X */\
                              50.00,   /* WDC90C2X */\
                              90.00,   /* WDC90C3X */\
                              55.00,   /* ATI */\
                              55.00,   /* ATIMACH32 */\
                              45.00    /* VIDEO7 */\
                            }


/*
 * Clock selection error codes (MUST be negative !!!)
 */

#define CLKSEL_OUT_OF_BOUNDS    -4
#define CLKSEL_DONOTHING        -3
#define CLKSEL_ILLEGAL_NUM      -2
#define CLKSEL_NULLCLOCK        -1

/*
 * clock stuff
 */

#define MAX_CLOCKS              64   /* I suppose there are no chipsets with more clocks out there */

#define MIN_CLOCK               0.0
#define MAX_CLOCK               500.0


#define SET_CLOCKBITS_0_1(no)   ( outb(( inb(VGA_MISC_R) & 0xf3) | (((no) << 2) & 0x0C) , VGA_MISC_W) ) /* bits 0 and 1 of clock no */


int GetClock(int chipset, float* clocks, int num_clocks, float freq, float *closestfreq, int optmask, int report_error);

void SetClock(int chipset, float* clocks, int num_clocks, float freq, int optmask);

void set_clockchip_clock(int chipset, int clockchip, long freq, int optmask);

#endif

