/*
 *       open.c open a vt to run a new command (or shell).
 *       
 *	 Copyright (c) 1994 by Jon Tombs <jon@gtex02.us.es>
 *
 *       This program is free software; you can redistribute it and/or
 *       modify it under the terms of the GNU General Public License
 *       as published by the Free Software Foundation; either version
 *       2 of the License, or (at your option) any later version.
 *
 * 4 May 1995 (tjd): removed need for this to be suid, cleaned up some
 */

#include "open.h"

const char *SWITCHTOversion = "switchto: 1.1 (c) Jon Tombs 1995";

int 
main(int argc, char *argv[])
{

   int fd;
   int vtno     = -1;
   struct vt_stat vt;

   if (argc < 2) 
 	usage(1);

   vtno = (int) atol(argv[1]);

   if (vtno <= 0 || vtno > MAX_NR_CONSOLES)
	usage(2);

   /* detect if we're running set-id or if we're root. */
   if(geteuid() != getuid() || getegid() != getgid() || !getuid())
   {
	if ((fd = open("/dev/console",O_WRONLY)) < 0) {
		perror("switchto: Can't open /dev/console\n");
		return(3);
	}
   }
   else	 /* not setuid/setgid */
   {
	if ((fd = open("/dev/tty",O_WRONLY)) < 0) {
		perror("switchto: Can't open /dev/tty\n");
		return(3);
	}
   
	if(ioctl(fd,VT_GETSTATE,&vt) < 0)
	{
	  fprintf(stderr,"This program may only be run on the console.\n");
	  close(fd);
          exit(1);
	}
    }

   if (ioctl(fd, VT_ACTIVATE, vtno) < 0) {
        fprintf(stderr, "switcho: Failed to select VT %d (%s)\n", vtno,
                strerror(errno));
	close(fd);
	return(3);
   }
	
   /* wait to be really sure we have switched */
   (void) ioctl(fd, VT_WAITACTIVE, vtno);

   close(fd);
   return 0;
}
      

void usage(int stat)
{
   fprintf(stderr,
      "Usage: switchto vt_num\n");
   exit (stat);
}
