/* close.c: closes specified or all inactive VC's
 *
 * todd j. derr <tjd@haven.zets.org>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 * 
 * v1.0: 2 April 1995
 *
 * based on:
 *
 *       open.c: open a vt to run a new command (or shell).
 *	 Copyright (c) 1994 by Jon Tombs <jon@gtex02.us.es>
 *
 */

#include "open-1.3/open.h"

const char *CLOSEversion = "close: v1.0: 2 April 1995";

#ifndef VTNAME
#error vt device name must be defined in open.h
#endif

int 
main(int argc, char *argv[])
{
   int fd, opt, i, vtno = -1;
   char verbose = FALSE;	
   struct vt_stat vt;

   while ((opt = getopt(argc, argv, "v")) != -1) {
      switch (opt) {
	case 'v':
	  verbose = TRUE;
	  break;	    	    
	default:
	  usage(1);
	
      }
   }
   
   /* detect if we're running set-id or if we're root. */
   if(geteuid() != getuid() || getegid() != getgid() || !getuid())
   {
	if ((fd = open("/dev/console",O_WRONLY,0)) < 0) {
		perror("switchto: Can't open /dev/console\n");
		return(3);
	}
   }
   else	 /* not setuid/setgid */
   {
	if ((fd = open("/dev/tty",O_WRONLY,0)) < 0) {
		perror("switchto: Can't open /dev/tty\n");
		return(3);
	}
   
	if(ioctl(fd,VT_GETSTATE,&vt) < 0)
	{
	  fprintf(stderr,"This program may only be run on the console.\n");
	  close(fd);
          exit(1);
	}
    }
	    
   if(argc==optind)
   {
	if(verbose) fprintf(stderr,"close: closing all non-active VCs\n");
	if (ioctl(fd, VT_DISALLOCATE, 0) < 0)
		perror("VT_DISALLOCATE");
   }

   else for(i=optind; i<argc; i++)
   {
	vtno=atol(argv[i]);

	if(verbose) fprintf(stderr,"closing vc %d",vtno);

	if (ioctl(fd, VT_DISALLOCATE, vtno) < 0) {
		if(!verbose) fprintf(stderr,"closing vc %d",vtno);
		perror(": VT_DISALLOCATE");
	}
	else
		if(verbose) fprintf(stderr,"\n");

   }
   close(fd);

   return 0;
}
      
void usage(int stat)
{
   fprintf(stderr,
      "Usage: close [-v] [vc...]\n");
   exit (stat);
}
