/* open_getty.c: spawns gettys on demand.
 *
 * todd j. derr <tjd@haven.zets.org>
 *
 * 	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 * some code in open_getty() was taken from:
 *
 *       open.c: open a vt to run a new command (or shell).
 *	 Copyright (c) 1994 by Jon Tombs <jon@gtex02.us.es>
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <syslog.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/vt.h>
#include <linux/kd.h>

#include "config.h"

#ifdef TTY
void create_utmp(pid_t,char *,int,gid_t);
#else
void create_utmp(pid_t,char *);
#endif

#ifdef TTY
void open_getty(int cons_fd, gid_t tty_gid)
#else
void open_getty(int cons_fd)
#endif
{
	int vt_fd,vtno;
	sigset_t m;
	pid_t child;

	/* be very careful with these!!! */
	#define VTNAME "/dev/tty%d"
	char vtname[sizeof VTNAME + 2];
	char *shortvtname=vtname+5;

	if ((ioctl(cons_fd, VT_OPENQRY, &vtno) < 0) || (vtno == -1)) {
		syslog(LOG_WARNING,"ioctl(VT_OPENQRY): %m\r\n");
		return;
	}

	sprintf(vtname, VTNAME, vtno);

	if (access(vtname, R_OK | W_OK) < 0) {
		syslog(LOG_WARNING,"access(%s): %m\r\n",vtname);
		return;
	}

#ifdef DEBUG
	syslog(LOG_DEBUG,"spawning a getty on VT %s\r\n",vtname);
#endif
	
	/* do this _before_ we fork() so there's no race condition */
	if ((vt_fd = open(vtname, O_RDWR)) == -1) {
		syslog(LOG_WARNING,"open(%s): %m\r\n",vtname);
		return;
	}

	switch(child=fork())
	{
		case -1:
			syslog(LOG_WARNING,"fork: %m\r\n");
			close(vt_fd);
			return;

		case 0:
			break;

		default:
#ifdef DEBUG
			syslog(LOG_DEBUG,"child pid is %d\r\n",child);
#endif
			close(vt_fd);
#ifdef TTY
			create_utmp(child,vtname,vtno,tty_gid);
#else
			create_utmp(child,vtname);
#endif
			return;
	}

	/* we're the child */

	close(cons_fd);

	sigemptyset(&m);	/* unblock all signals */

	if(sigsetmask(m) < 0)
	{
		syslog(LOG_WARNING,"sigsetmask(): %m\r\n");
		exit(7);
	}

	if (setsid() < 0) {
		syslog(LOG_WARNING,"setsid(): %m\r\n");
		exit(8);
      	}

	if(vt_fd!=3) {
		dup2(vt_fd,3);
		close(vt_fd);
	}

	dup2(3,0); dup2(3,1); dup2(3,2); close(3);

#ifdef SHOW_VC
        if(ioctl(0, VT_ACTIVATE, vtno)<0)
	{
		syslog(LOG_WARNING,"ioctl(VT_ACTIVATE): %m\r\n");
	}

	if(ioctl(0, VT_WAITACTIVE, vtno)<0)
	{
		syslog(LOG_WARNING,"ioctl(VT_WAITACTIVE): %m\r\n");
	}
#endif

	EXEC_GETTY;	/* defined above as execl("getty"....) */

	/* shouldn't get here */
	syslog(LOG_WARNING,"exec(getty): %m\r\n");

	exit(9);
}
