/* LOCKVC Version 1.8 (c) 1994, 1995 by Matthias Straub */
/* shadow-password option added by Ed Beaumont */
/* integer math derived from a patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */
		
#define MAXNUMSTARS 2000
#define SFLENGTH 1024          /* twice DIST */
#define SFWIDTH 400
#define SFHEIGHT 400
#define DIST 512               /* should be a power of 2 for speed */
#define SCRX 320               /* .EQ. vga-mode */
#define SCRY 240               /* .EQ. vga-mode */
#define CONFIG "/etc/maxlock"  /* change if you don't like the filename */
#define UMODE 0                /* key-mode    */
#define SMODE 1                /* passwd-mode */
#define FPBITS 10
#define FM(x,y) (((x)*(y))>>FPBITS)
#define FM3(x,y,z) (((x)*(y)*(z))>>(2*FPBITS))
#define SIN(x) (sintab[(x)&4095])
#define COS(x) SIN(x+256*4)
 
#ifdef SHADOW_PASSWD
  #include <shadow.h>
#endif
#include <sys/stat.h>
#include <pwd.h>
#include <signal.h>
#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vga.h>
#include <termio.h>

int numstars;
int xr[MAXNUMSTARS];
int yr[MAXNUMSTARS];
int zr[MAXNUMSTARS];
int xbuf[2][MAXNUMSTARS];
int ybuf[2][MAXNUMSTARS];
int sintab[4096];
char page=1;
int offset=0; 
int IS11,IS12,IS13,IS21,IS22,IS23,IS31,IS32,IS33; 
int s,t,u;	 
int i;
char stride;
char buff[100];
char key[100];
char rkey[100];
char uname[100];
struct termios console;
#ifdef SHADOW_PASSWD
struct spwd *sword;
struct spwd *rpword;
char name[32];
#else
struct passwd *rpword;
#endif
struct passwd *pword;
int keymode;

void mksintab()
     {
	for(i=0;i<4096;i++)
	  {
	     sintab[i]=(int)(sin(i*M_PI*2.0/4096)*1024);
	  }
     }
 
void isconsole() /* vgalib1.2 */
     {
	struct stat chkbuf;
	int major, minor;
	int fd;
	
	fd = dup(2);
	fstat(fd, &chkbuf);
	major = chkbuf.st_rdev >> 8;
	minor = chkbuf.st_rdev & 0xff;
	
	if (major != 4 || minor >= 64)
	  {
	     printf("Not running in graphics-capable virtual console.\n");
	     exit(-1);
	  }
	close(fd);            
     }
             
void kickout() 
     {
	setuid(getuid());
	kill(-1,SIGTERM);
	sleep(2);
	kill(-1,SIGKILL);
	exit(0);
     }

void res_term()
     {
	tcsetattr(STDIN_FILENO, TCSANOW, &console);
     }

void invis_term()
     {
	struct termios terminal;
	tcgetattr(STDIN_FILENO, &console);
	terminal=console;
	terminal.c_lflag &= !(ECHO | ECHOCTL);
	tcsetattr(STDIN_FILENO, TCSANOW, &terminal);
     }

void initfield() 
     {
       	for (i=0;i<numstars;i++) 
	  {
		xr[i]=SFWIDTH-random()%(SFWIDTH<<1);
		yr[i]=SFHEIGHT-random()%(SFHEIGHT<<1);
		zr[i]=random()%SFLENGTH-SFLENGTH/2;
	  }
     }

void initpalette() 
     {
	int j;
	for (j=0;j<64;j++)
	  {
	     vga_setpalette(j,j,j,j);
	  }
	for (j=64;j<=80;j++)
	  {
	     vga_setpalette(j,63,63,63);
	  }
     }

void plotfield(void)
     {
	int q,qq,x2,y2,z2,xl,yl;
	
		
	/* looks weird, doesn't it? */
	/* it's just the */
	/* product of 3 less */
	/* spectacular matrices */
	/* that's what one year */
	/* linear algebra class */
	/* was for */
	IS11 = FM(COS(s),COS(t));
	IS12 = FM(SIN(s),COS(t));
	IS13 = -SIN(t);
	IS21 = -FM(SIN(s),COS(u))+FM3(COS(s),SIN(t),SIN(u));
	IS22 = FM(COS(s),COS(u))+FM3(SIN(s),SIN(t),SIN(u));
	IS23 = FM(COS(t),SIN(u));
	IS31 = FM(SIN(s),SIN(u))+FM3(COS(s),SIN(t),COS(u));
	IS32 = -FM(COS(s),SIN(u))+FM3(SIN(s),SIN(t),COS(u));
	IS33 = FM(COS(t),COS(u));
	
	 

	page=1-page;
	offset=SCRY-offset;
	vga_setdisplaystart((SCRY-offset)*SCRX); 
	vga_waitretrace();
	
	vga_setcolor(0);              
	for (i=0;i<numstars;i++)
	  {
	     x2=xbuf[page][i];
	     y2=ybuf[page][i];
	     if (x2<SCRX && y2 < (SCRY+offset) && x2>=0 && y2 >= offset)
	       {
		  vga_drawpixel(x2,y2);
	       }
	  }

	for (i=0;i<numstars;i++) 
	  {
	     zr[i]=zr[i]+stride;
	     if (zr[i]>SFLENGTH/2) zr[i]=-SFLENGTH/2;
	     z2 = (IS13*xr[i]+IS23*yr[i]+IS33*zr[i])>>FPBITS; 
	     if (z2!=DIST) q=(DIST-z2);
	     else q=1;
	     qq=q>>1;
	     x2 = (DIST*((int)(IS11*xr[i]+IS21*yr[i]+IS31*zr[i])>>FPBITS)+qq)/q;
	     y2 = (DIST*((int)(IS12*xr[i]+IS22*yr[i]+IS32*zr[i])>>FPBITS)+qq)/q;
	     xbuf[page][i]=((x2+2)>>2)+SCRX/2;
	     ybuf[page][i]=SCRY/2-((y2+2)>>2)+offset;
	     xl=xbuf[page][i];
	     yl=ybuf[page][i];
	     if (xl >=0 && xl <SCRX && yl >=offset && yl < (SCRY+offset) && z2<=DIST && z2>=-DIST)
	       {
		  vga_setcolor(40+(z2*40)/DIST);
		  vga_drawpixel(xl,yl);
	       }
	  }
	
	if(vga_getkey()!=0 && vga_getkey()!=-1) 
	  {
	     vga_setmode(TEXT);
	     if(keymode==UMODE)
	       {
		  printf("\nEnter key to unlock: ");
		  gets(buff);
		  printf("\n");
		  if(strcmp(buff,key)==0)
		    {
		       memset(buff,0,strlen(buff));
		       memset(key,0,strlen(key));
		       res_term();
		       exit(0);
		    }
	       }
	     else 
	       {
		  printf("\n%s's password: ",uname);
		  gets(buff);
		  printf("\n");
		  /* 13 chars should be save enough -> */
		  if((strncmp(key,crypt(buff,key),13)==0)||strncmp(rkey,crypt(buff,rkey),13)==0)
		    {
		       memset(buff,0,strlen(buff));
		       res_term();
		       exit(0);
		    }
	       }
	     vga_setmode(G320x240x256);
	     initpalette();
	  }
     }

void main(int argc,char **argv)
     {
	int j;
	FILE *config;
	int maxtime;
	printf("\n---     Starfield-Virtual-Console-Lock by M.Straub '94 V1.8     ---\n");
	printf(  "---     usage:  lockvc  [ <number of stars>  <stride> ]		---\n"); 
	if(((config=fopen(CONFIG,"r"))!=NULL) && (getuid()!=0))
	  {
	     fscanf(config,"%i",&maxtime);
	     printf("---     locking-time is limited to %i minutes.			---\n",maxtime);
	     maxtime*=60;
	     alarm(maxtime);
	     signal(SIGALRM,kickout);
	     fclose(config);
	  }
	if(argc ==3)
	  {
	     numstars=atoi(argv[1]);
	     stride=atoi(argv[2]);
	     if(numstars<1 || numstars>1000) 
	       {printf("Number of stars must be between 1 and 1000.\n");exit(-1);}
	     if(stride<0 || stride >100)
	       {printf("Stride must be between 0 and 100.\n");exit(-1);}
	  }
	else 
	  {
	     numstars=500;
	     stride=9;
	  }
	if(((pword=getpwuid(getuid()))!=NULL) && (strlen(pword->pw_passwd)>0))
	  {
#ifdef SHADOW_PASSWD
	     if(setuid(0) != 0) printf("setuid failed. Bet setreuid will too....\n");
	     if(setreuid(0,0) != 0)
	       {
		  if(errno == EPERM)
		    printf("Program not SUIDed - shadow passwords wont work!\n");
		  else
		    printf("ERROR: Type %i returned from setuid()\n",errno);
		  vga_init();
		  isconsole();
		  invis_term();
		  do
		    {
		       printf("\nKey: ");
		       gets(key);
		       printf("\nAgain: ");
		       gets(buff);
		    } while(strcmp(key,buff)!=0);
		  keymode=UMODE;
	       }
	     else	
	       {
		  name[0]='\0';
		  strncpy(name,pword->pw_name, sizeof(char[32]));	
		  if((sword=getspnam(name))==NULL)
		    printf("getspnam() failed!\n");
		  strcpy(key,sword->sp_pwdp);
		  strcpy(uname,sword->sp_namp);
		  rpword=getspnam("root");
		  strcpy(rkey,rpword->sp_pwdp);
		  keymode=SMODE;
		  vga_init();
		  isconsole();
		  invis_term();
	       }
#else
	     strcpy(key,pword->pw_passwd);
	     strcpy(uname,pword->pw_name);
	     rpword=getpwuid(0);
	     strcpy(rkey,rpword->pw_passwd);
	     keymode=SMODE;
	     vga_init();
	     isconsole();
	     invis_term();
#endif
	  }
	else
	  {
	     vga_init();
	     isconsole();
	     invis_term();
	     do
	       {
		  printf("\nKey: ");
		  gets(key);
		  printf("\nAgain: ");
		  gets(buff);
	       } while(strcmp(key,buff)!=0);
	     keymode=UMODE;
	  }
	vga_lockvc();
	initfield ();
	mksintab();    
	vga_setmode(G320x240x256); 
	signal(SIGINT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGABRT,SIG_IGN);
	initpalette();
	for (j=0;j<200;j++)
	  {
	     plotfield ();
	  }
	while(1)
	  {
	     for (j=0;j<2048;j++)
	       {
		  plotfield ();
		  s+=2;
		  t+=5;
		  u+=7;
	       }
	  }
     }
