
/* logiso_stop.c  
   Usage:	logiso_stop  cd-mount-point-or-file
      Stop the isofs log.
*/
/* (C) Copyright 1995 by Michael Coulter.  All rights reserved. */

#include <fcntl.h>
#include <linux/iso_fs.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

#define FALSE		0
#define TRUE		1

extern void print_usage();

main(int argc, char** argv)
{
   struct iso_log_entry*	entry_p;
   struct iso_log_entry*	entry_limit_p;
   int				file_id;
   FILE*			out_fp;
   struct iso_log_info		iso_log_info;
   int				result;
   int				verbose;

   /* file_id = open("/mnt/system_cd/FileList", O_RDONLY); */
   file_id = open(argv[1], O_RDONLY); 
   if (file_id == -1) {
      fprintf(stderr, "Unable to open file.\n");
      exit(1);
   }

   result = ioctl(file_id, ISO_IOC_STOPLOG);
   if (result != 0) {
      fprintf(stderr, 
      	      "Expected result 0, got %d.\n", 
      	      result);
      exit(1);
   }
   fclose(out_fp);
   return 0;
} /* end main */

