#ifndef _GC3_H
#define _GC3_H

#include "gcboth.h" /* stuff common to compiler and interpreter */

#define MAXFILEINFO	35	/* Maximum displayed filename length */

/********************************************************
	DOS-SPECIFIC STUFF
*********************************************************/

#ifdef __MSDOS__

#define CHDIR		mychdir
#define BEEP		(void)putch(7)

/*
 * Executable file permissions
 */

#define S_IXUSR		S_IEXEC
#define S_IXGRP		S_IEXEC
#define S_IXOTH		S_IEXEC

/* 
 * POSIX file attribute macros
 */

/* macro to test for directory file */
#define	S_ISDIR( mode )		((mode) & S_IFDIR)
/* macro to test for character special file */
#define	S_ISCHR( mode )		((mode) & S_IFCHR)
/* macro to test for block special file */
#define	S_ISBLK( mode )		((mode) & S_IFBLK)
/* macro to test for fifo */
#define	S_ISFIFO( mode )	((mode) & S_IFIFO)
/* macro to test for regular file */
/*#define	S_ISREG( mode )		((mode) & S_IFREG)*/
/* The previous form causes lint to complain about signed/unsigned
   mixing. Here is a more explicit alternative. */
#define	S_ISREG( mode )		(((mode) & 0x7000)==0)

/***************************************************************/

#define PATH_SEP	'\\'
#define COLS		80
#define NUM_INFO_LNS	2
#define NUM_FILES	(20-NUM_INFO_LNS)

typedef int	uid_t;
typedef int	gid_t;
typedef short	mode_t;
typedef long	off_t;
typedef long	time_t;

typedef struct {
	char		*name;
	unsigned char	flag;
	char		typID;
	off_t		size;
	mode_t		mode;
	uid_t		uid;
	gid_t		gid;
	time_t		modtime;
	time_t		acctime;
} fInfo_t;

#define MAXPATHNAME	64
#define MAXFILENAME	13

#endif

/********************************************************
	UNIX-SPECIFIC STUFF
*********************************************************/

#ifndef __MSDOS__

#ifdef NO_UID_T
typedef long	uid_t;
typedef long	gid_t;
#endif

#define CHDIR		chdir

#ifdef SYS_V
#if __STDC__
extern int beep(void);
#else
extern int beep();
#endif
#define BEEP		beep()
#else
#define BEEP		putc(7,stdout)
#endif

/* 
 * POSIX file attribute macros
 */

#ifndef S_ISDIR				/* macro to test for directory file */
#define	S_ISDIR( mode )		(((mode) & S_IFMT) == S_IFDIR)
#endif

#ifndef S_ISCHR				/* macro to test for character special file */
#define	S_ISCHR( mode )		(((mode) & S_IFMT) == S_IFCHR)
#endif

#ifndef S_ISBLK				/* macro to test for block special file */
#define	S_ISBLK( mode )		(((mode) & S_IFMT) == S_IFBLK)
#endif

#ifndef S_ISFIFO			/* macro to test for fifo */
#define	S_ISFIFO( mode )	(((mode) & S_IFMT) == S_IFIFO)
#endif

#ifndef S_ISREG				/* macro to test for regular file */
#define	S_ISREG( mode )		(((mode) & S_IFMT) == S_IFREG)
#endif

#ifndef S_ISLNK
#ifndef S_IFLNK
#define S_ISLNK( mode )		0
#else
#define	S_ISLNK( mode )		(((mode) & S_IFMT) == S_IFLNK)
#endif
#endif

/***************************************************************/

#define PATH_SEP	'/'
#define NUM_INFO_LNS	4
#define NUM_FILES	(Lines-NUM_INFO_LNS-5)

typedef struct {
	char		*name;
	unsigned char	flag;
	char		typID;
	off_t		size;
	mode_t		mode;
	uid_t		uid;
	gid_t		gid;
	time_t		modtime;
	time_t		acctime;
} fInfo_t;

#if __STDC__
extern void clrscr(void);
#else
#endif
extern void clrscr();
#endif

/********************************************************
	GENERIC STUFF
*********************************************************/

/*
 * Loop types
 */

#define PAT_LOOP	1
#define ALL_LOOP	2
#define MARK_LOOP	3

typedef struct {
	short v;
	short type;
	short idx;
	short s, e;
	short pos;
} loopInfo;

#define F_SELECTED	1

/*************** PROTOTYPES *******************/

#if __STDC__

/* from gc3.c */

int readFile(char *name, char *aname,int (*f)(char *));

/* from gckey.c */

int	my_getch(void);
int	EditString(int c, char *start, char **end, char **now,
			int *insmode, int maxlen);
void	setKeycode(short key, int code);
int	getKeyBinding(int ch, int doIt);
void	playMacro(short MNum);
void	recordMacro(short MNum);
void	endRecord(void);
void	saveHist(char *b);

/* from gcterp.c */

int	getBuffer(int who);
void	releaseBuffer(int buf, int who);
void	freeVars(void);
int	findFile(int s, char *fname, int *idx);
void	doDefaultAction(int ch);
int	execute(short IP, int ch);
void	readcodefile(void);
char	*lookupVar(short idx, int buf);
void	assign2var(short varnum, char *val);

/* From eval.c */

char	*compute(char *str, int *rtn);

/* From gcdisk.c */

char	*getPerms(mode_t tmd);
int	checkType(mode_t m, short f);
void	refilter(int l, char *oldname);
void	readList(int n, char *name, int newpath);
void	freeNames(int n);
void	getCWD(char *name);
void	doCD(char *d, char *oldname);
void	savePath(void);
void	dirInit(int args, char *arg1, char *arg2);
#ifdef __MSDOS__
void	mychdir(char *d);
#endif
void	getDiskSpace(char *path);
int	doFileCopy(char *src, char *dest, int del);
void	cd2old(void);

/* From select.c */

/*void	pselect(fInfo_t *p, int v);*/
/*void	nselect(int n, int v);*/

/* From screen.c */

void	showCursor(int n, int sel);
void	hideCursor(int n);
void	clearCmdWin(void);
void	showMsg(char *txt);
int	getInput(char *buf, int len, int mode);
void	setupCurses(char *version);
void	showPath(int p);
/*void	showStatus(int n);*/
/*void	showInfo(int n, int r, int i);*/
void	showList(int n);
void	normalise(int n);
void	refreshScreen(void);
void	repaintScreen(void);
void	exitCurses(void);
void	setColorAttr(short fg, short bg);
void	cursorUp(void);
void	cursorDown(void);
void	cursorPgUp(void);
void	cursorPgDn(void);
void	cursorHome(void);
void	cursorEnd(void);
int	readKey(void);

/* From gcsort.c */

void	sortList(int n,char *name);
void	resortList(int l, int isRev, short key);

/* From regexp.c */

char	*compileRE(char *RE);
int	matchRE(char *string);

#else /* NON_ANSI DECLARATIONS *************************************/

/* from gc3.c */

int readFile();

/* from gckey.c */

int	my_getch();
int	EditString();
void	setKeycode();
int	getKeyBinding();
void	playMacro();
void	recordMacro();
void	endRecord();
void	saveHist();

/* from gcterp.c */

int	getBuffer();
void	releaseBuffer();
void	freeVars();
int	findFile();
void	doDefaultAction();
int	execute();
void	readcodefile();
char	*lookupVar();
void	assign2var();

/* From eval.c */

char	*compute();

/* From gcdisk.c */

char	*getPerms();
int	checkType();
void	refilter();
void	readList();
void	freeNames();
void	getCWD();
void	doCD();
void	savePath();
void	dirInit();
int	doFileCopy();
void	getDiskSpace();
void	cd2old();

/* From select.c */

/*void	pselect();*/
/*void	nselect();*/

/* From screen.c */

void	showCursor();
void	hideCursor();
void	clearCmdWin();
void	showMsg();
int	getInput();
void	setupCurses();
void	showPath();
/*void	showStatus();*/
/*void	showInfo();*/
void	showList();
void	normalise();
void	refreshScreen();
void	repaintScreen();
void	exitCurses();
void	setColorAttr();
void	cursorUp();
void	cursorDown();
void	cursorPgUp();
void	cursorPgDn();
void	cursorHome();
void	cursorEnd();
int	readKey();

/* From gcsort.c */

void	resortList();
void	sortList();

/* From regexp.c */

char	*compileRE();
int	matchRE();

#endif

/*************** GLOBAL VARIABLES *******************/

extern long		freeSpace,
			usedSpace,
			selSize[2];
extern fInfo_t		fInfo[2][MAXARGS]; /* Directory info for windows */
extern char		tempName[MAXPATHNAME],
			filters[2][64],
			scrap[2048],
			srchTxt[80],
			BUF[MAX_BUFFERS][BUFFER_SIZE],
			paths[2][MAXPATHNAME];
extern int		metaMode,
			allowColor,
			numfiles[2],
			fIndex[2][MAXARGS],
			highlight[2],
			startLn[2],
			selCnt[2],
			Lines,
			searching,
			fnameLen,
			dirsFirst,
			showHidden,
			noDirSelect,
			followLinks,
			metaKey,
			l;
extern short		info2show,
			escapeCh;

#endif

