#include <stdio.h>
#include <string.h>
#include "gccc.h"
#include "gcmem.h"

#define MAXKEY			631

typedef	struct namerecord	*namerecordp;

struct namerecord {
        namerecordp	nextname;
        short		IDindex;	/* Identifier index */
};

namerecordp 	hash[MAXKEY] = {NULL};
short		varcnt = 0;
short		lastReserved,
		lastPredef,
		firstUserID;

#if __STDC__
short key(char *keytext) {
#else
short key(keytext)
	char *keytext;
{
#endif
	short sum=0;
	while (*keytext) {
	        sum += *keytext++;
		sum %= 32641 		/* 32768-127 */;
        }
	return sum % MAXKEY;
}

#if __STDC__
void insert(char *name, short IDindex, short type) {
#else
void insert(name, IDindex, type)
	char *name;
	short IDindex, type;
{
#endif
	namerecordp np;
	short keyno = key(name);
	namemap[IDindex] = savestring(name);
	objects[IDindex].p = (type&FUNC_TYPE)?-1:(varcnt++);
	objects[IDindex].type = type;
	if ((np=(namerecordp)Mem_Calloc(1,sizeof(struct namerecord),4))!=NULL) {
		np->nextname = hash[keyno];
		np->IDindex = IDindex;
		hash[keyno] = np;
	} else error(ERR_MALLOC);
}

#if __STDC__
void freeStab(void) {
#else
void freeStab()
{
#endif
	int i;
	for (i=0; i<MAXKEY; i++) {
		while (hash[i]) {
			namerecordp tmp = hash[i];
			hash[i] = hash[i]->nextname;
			Mem_Free((char *)tmp,12);
		}
	}
}

#if __STDC__
short findID(char *name) {
#else
short findID(name)
	char *name;
{
#endif
	namerecordp np;
	short keyno = key(name);
	np = hash[keyno];
	while (np) {
		if (strcmp(name,stringspace+namemap[np->IDindex])==0)
			break;
		else np = np->nextname;
	}
	if (np) return np->IDindex;
	else return 0;
}

#if __STDC__
namerecordp lookup(char *name) {
#else
namerecordp lookup(name)
	char *name;
{
#endif
	namerecordp np;
	short keyno = key(name);
	for (np = hash[keyno] ; np ; np = np->nextname) {
	fflush(stdout);
                if (strcmp(name,stringspace+namemap[np->IDindex])==0) 
			break;
	}
	return np;
}

#if __STDC__
short search(char *name, short type) {
#else
short search(name, type) 
	char *name;
	short type;
{
#endif
	namerecordp np;
	if ((np = lookup(name)) == NULL) {
		if (idents >= MAXVARS) error(ERR_VARS);
		insert(name,idents,type);
		return idents++;
        } else return np->IDindex;
}

#define initVar(n)	insert(n,idents++,VAR_TYPE)

#if __STDC__
void initvars(void) {
#else
void initvars() {
#endif
/* 0 */	initVar("PFILE");
/* 1 */	initVar("SFILE");
/* 2 */	initVar("PFILES");
/* 3 */	initVar("SFILES");
/* 4 */	initVar("PPATH");
/* 5 */	initVar("SPATH");
/* 6 */	initVar("PSEL");
/* 7 */	initVar("SSEL");
/* 8 */	initVar("PSELSIZE");
/* 9 */	initVar("SSELSIZE");
/* 10*/	initVar("PSELCNT");
/* 11*/	initVar("SSELCNT");
/* 12*/	initVar("PSIZE");
/* 13*/	initVar("SSIZE");
/* 14*/	initVar("NAME"); /* login name */
/* 15*/	initVar("TEMPNAME");
/* 16*/	initVar("LINEBUFF");
/* 17*/	initVar("DATE");
/* 18*/	initVar("TIME");
/* 19*/	initVar("RANDOM");
/* 20*/	initVar("PREVCMD");
/* 21*/	initVar("NEXTCMD");
/* 22*/ initVar("DISKFREE");
/* 23*/ initVar("DISKUSED");
/* 24*/ initVar("MESSAGE");
/* 25*/ initVar("SHELL");
/* 26*/ initVar("CH");
}

