/* TInfo.h --- The long filename window class  

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _TInfo_h
#define _TInfo_h

extern "C" {
#include <ncurses/ncurses.h>
}

#include "globals.h"
#include "config.h"

class TInfo
  {
  private:
    WINDOW *wptr;

  public:
    TInfo( void )
      {
	wptr = newwin( 1, SCR_X, SCR_Y-7, 0 );
	cbreak();
      }
    
    ~TInfo()
      {
      delwin( wptr );
      }

    void show( char *text )
      { werase( wptr ); waddstr( wptr, text ); wrefresh( wptr ); }

    WINDOW* getwptr( void )
      { return( wptr ); }

  };


#endif


